/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder;

import cn.net.vidyo.framework.builder.build.DatabaseMetaBuildExecuter;
import cn.net.vidyo.framework.builder.config.DataSourceConfig;
import cn.net.vidyo.framework.builder.config.GlobalConfig;
import cn.net.vidyo.framework.builder.config.Module;
import cn.net.vidyo.framework.builder.config.Project;
import cn.net.vidyo.framework.builder.config.ProjectItem;
import cn.net.vidyo.framework.builder.domain.DbColumnType;
import cn.net.vidyo.framework.builder.domain.IExtendHandler;
import cn.net.vidyo.framework.builder.engine.FreemakerTemplateEngine;
import cn.net.vidyo.framework.builder.meta.ColumnSchema;
import cn.net.vidyo.framework.builder.meta.DatabaseSchema;
import cn.net.vidyo.framework.builder.meta.TableSchema;
import cn.net.vidyo.framework.builder.template.ITemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Generator {
    DatabaseMetaBuildExecuter databaseMetaBuildExecuter;
    DataSourceConfig dataSourceConfig;
    List<IExtendHandler> extendHandlers = new ArrayList<IExtendHandler>();
    public static final String AUTHOR = "author";
    public static final String NAMESPACE = "namespace";
    public static final String OUT_PATH = "outpath";
    public static final String PROJECT = "project";
    public static final String MODULE = "module";
    public static final String TABLE = "table";
    public static final String ENTITYNAME = "";

    public Generator setDatabaseMetaBuildExecuter(DatabaseMetaBuildExecuter executer) {
        this.databaseMetaBuildExecuter = executer;
        return this;
    }

    public Generator addExtend(IExtendHandler ... extendHandlers) {
        for (IExtendHandler extendHandler : extendHandlers) {
            this.extendHandlers.add(extendHandler);
        }
        return this;
    }

    public void go(Project project) {
        FreemakerTemplateEngine engine = new FreemakerTemplateEngine();
        engine.init();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(PROJECT, project);
        for (ProjectItem projectItem : project.getItems().toArray(new ProjectItem[0])) {
            Module module = (Module)projectItem;
            model.put(MODULE, module);
        }
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setDateType(project.getDateType());
        globalConfig.setDataSourceConfig(this.dataSourceConfig);
        DatabaseSchema databaseSchema = this.databaseMetaBuildExecuter.build();
        List<TableSchema> tableSchemas = databaseSchema.getTables();
        for (TableSchema tableSchema : tableSchemas) {
            model.put(TABLE, tableSchema);
            if (tableSchema.getComment().length() == 0) {
                tableSchema.setComment(project.getAlias(tableSchema.getName()));
            }
            for (ColumnSchema columnSchema : tableSchema.getColumns()) {
                if (columnSchema.getComment().length() == 0) {
                    columnSchema.setComment(project.getAlias(columnSchema.getName()));
                }
                if (columnSchema.getName().equalsIgnoreCase("status")) {
                    tableSchema.setIncludeStatus(true);
                }
                if (columnSchema.getName().equalsIgnoreCase("name")) {
                    tableSchema.setIncludeName(true);
                }
                if (columnSchema.getName().equalsIgnoreCase("extend") && columnSchema.getColumnType() == DbColumnType.STRING) {
                    tableSchema.setIncludeExtend(true);
                }
                if (columnSchema.getName().equalsIgnoreCase("pid")) {
                    tableSchema.setIncludePid(true);
                }
                if (project.isAutoComponentField(columnSchema.getName())) {
                    columnSchema.setAutoComponentField(true);
                }
                if (project.isBusinessComponentField(columnSchema.getName())) {
                    columnSchema.setBusinessComponentField(true);
                }
                if (project.isExcludeComponentField(columnSchema.getName())) {
                    columnSchema.setExcludeComponentField(true);
                }
                if (project.isDisplayNameField(columnSchema.getName())) {
                    columnSchema.setDisplayNameField(true);
                }
                if (!project.isAutoComponentConditionField(columnSchema.getName())) continue;
                columnSchema.setAutoComponentConditionField(true);
            }
            for (ProjectItem projectItem : project.getItems().toArray(new ProjectItem[0])) {
                Module module = (Module)projectItem;
                if (module.isExcludeTable(tableSchema.getName())) continue;
                model.put(MODULE, module);
                model.put("baseNamespace", module.getFullNamespace());
                model.put("entityNamespace", module.getFullNamespace() + ".data.entity");
                model.put("autoConditionNamespace", module.getFullNamespace() + ".data.auto.condition");
                model.put("conditionNamespace", module.getFullNamespace() + ".data.condition");
                model.put("converterNamespace", module.getFullNamespace() + ".data.converter");
                model.put("daoNamespace", module.getFullNamespace() + ".data.auto.dao");
                model.put("autoServiceNamespace", module.getFullNamespace() + ".data.auto.service");
                model.put("autoServiceImplNamespace", module.getFullNamespace() + ".data.auto.service.impl");
                model.put("serviceNamespace", module.getFullNamespace() + ".data.service");
                model.put("serviceImplNamespace", module.getFullNamespace() + ".data.service.impl");
                model.put("controllerNamespace", module.getFullNamespace() + ".web.auto");
                for (IExtendHandler extendHandler : this.extendHandlers) {
                    extendHandler.process(model, tableSchema, projectItem, module);
                }
                for (ITemplate template : module.getTemplateMap().values()) {
                    engine.write(globalConfig, template, model);
                }
            }
        }
    }

    public void test() {
    }
}

