package cn.net.vidyo.framework.builder.meta;

import cn.net.vidyo.framework.builder.domain.DbColumnType;
import cn.net.vidyo.framework.builder.domain.IColumnType;
import cn.net.vidyo.framework.common.util.ValueUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class ColumnSchema {
    String name ="";
    String comment ="";
    String propertyName="";
    String entityName ="";
    private String dataTypeName;
    private Integer Length=0;
    public String dbColumnTypeString;
    IColumnType columnType;
    boolean primaryKey;

    boolean autoComponentField=false;
    boolean businessComponentField=false;
    boolean excludeComponentField=false;
    boolean displayNameField=false;
    boolean autoComponentConditionField=false;

    /**
     * 自定义查询字段列表
     */
    private Map<String, Object> customMap=new HashMap<>();


    public void convert(){
//        System.out.println(dataTypeName);
    }

    public String firstCapitalLetterName(){
        return ValueUtil.firstCapitalLetterName(name);
    }
    public String getFirstLowercaseLetterName(){
        return ValueUtil.firstLowercaseLetterName(name);
    }


    public String getGetMethodName(){
        if(columnType== DbColumnType.BOOLEAN){
            return "is"+ firstCapitalLetterName();
        }
        return "get"+ firstCapitalLetterName();
    }

    public String getEntityName() {
        return entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public boolean isExcludeComponentField() {
        return excludeComponentField;
    }

    public void setExcludeComponentField(boolean excludeComponentField) {
        this.excludeComponentField = excludeComponentField;
    }

    public boolean isDisplayNameField() {
        return displayNameField;
    }

    public void setDisplayNameField(boolean displayNameField) {
        this.displayNameField = displayNameField;
    }

    public String getCompareDefaultString(){
        if(columnType==null){
            System.out.println("");
        }
        if(columnType== DbColumnType.INTEGER ||
                columnType== DbColumnType.LONG ||
                columnType== DbColumnType.SHORT ||
                columnType== DbColumnType.DOUBLE ||
                columnType== DbColumnType.FLOAT ||
                columnType== DbColumnType.BASE_SHORT ||
                columnType== DbColumnType.BASE_DOUBLE ||
                columnType== DbColumnType.BASE_FLOAT ||
                columnType== DbColumnType.BASE_INT ||
                columnType== DbColumnType.BASE_LONG
        ){
            return ">0";
        }
        if(columnType== DbColumnType.STRING){
            return ".length()>0";
        }
        if(columnType== DbColumnType.BOOLEAN){
            return "!=null";
        }
        return "!="+columnType.getDefaultValue();
    }

      public String getSetMethodName(){
        return "set"+ firstCapitalLetterName();
    }

    public boolean isAutoComponentField() {
        return autoComponentField;
    }

    public void setAutoComponentField(boolean autoComponentField) {
        this.autoComponentField = autoComponentField;
    }

    public boolean isBusinessComponentField() {
        return businessComponentField;
    }

    public void setBusinessComponentField(boolean businessComponentField) {
        this.businessComponentField = businessComponentField;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = ValueUtil.firstLowercaseLetterName(name);
        this.propertyName= getFirstLowercaseLetterName();
        this.entityName =ValueUtil.firstUppercaseLetterName(name);
    }

    public String getCommentString() {
        if(comment!=null && comment.length()>0)
            return comment;
        return name;
    }

    public boolean isAutoComponentConditionField() {
        return autoComponentConditionField;
    }

    public void setAutoComponentConditionField(boolean autoComponentConditionField) {
        this.autoComponentConditionField = autoComponentConditionField;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getDataTypeName() {
        return dataTypeName;
    }

    public void setDataTypeName(String dataTypeName) {
        this.dataTypeName = dataTypeName;
    }

    public Integer getLength() {
        return Length;
    }

    public void setLength(Integer length) {
        Length = length;
    }

    public String getDbColumnTypeString() {
        return dbColumnTypeString;
    }

    public void setDbColumnTypeString(String dbColumnTypeString) {
        this.dbColumnTypeString = dbColumnTypeString;
    }

    public IColumnType getColumnType() {
        return columnType;
    }

    public void setColumnType(IColumnType columnType) {
        this.columnType = columnType;
    }

    public boolean isPrimaryKey() {
        return primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Map<String, Object> getCustomMap() {
        return customMap;
    }

    public void setCustomMap(Map<String, Object> customMap) {
        this.customMap = customMap;
    }

}
