package cn.net.vidyo.framework.builder.engine;

import cn.net.vidyo.framework.builder.TemplateModel;
import cn.net.vidyo.framework.builder.config.GlobalConfig;
import cn.net.vidyo.framework.builder.config.Module;
import cn.net.vidyo.framework.builder.config.Project;
import cn.net.vidyo.framework.builder.meta.TableSchema;
import cn.net.vidyo.framework.builder.template.ITemplate;
import freemarker.template.Template;
import org.springframework.core.io.ClassPathResource;

import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.util.Map;

public abstract class AbstractTemplateEngine implements ITemplateEngine {
    public boolean write(GlobalConfig globalConfig, ITemplate template, Object model) {
        String outputDir = globalConfig.getOutputDir();
        Object tableName = "";
        String outFilePath = "";
        String fileName="";
        String defaultTemplatPath="template/default/";
        String customTemplatPath="";
        if ((model instanceof TemplateModel)) {
            TemplateModel tmodel = (TemplateModel) model;
            if(template.isFileNameAddTableName()){
                fileName=template.getPrefix() + tmodel.getModel().get("entityName") + template.getPostfix();
            }else{
                fileName=template.getPrefix()+ template.getPostfix();
            }
            if(template.isPathAddEntity()){
//                outFilePath = outputDir + template.getPath() + File.separator + tmodel.getModel().get("entityName") + File.separator + fileName;
                outFilePath = outputDir + template.getPath() + File.separator + tmodel.getModel().get("name") + File.separator + fileName;
            }else{
                outFilePath = outputDir + template.getPath() + File.separator + fileName;
            }
        } else {
            Map map = (Map) model;
            Project project = (Project) map.get("project");
            defaultTemplatPath=project.getDefaultTemplatePath();
            customTemplatPath= project.getTemplatePath();
            Module module = (Module) map.get("module");
            TableSchema tableSchema = (TableSchema) map.get("table");
            if(template.isFileNameAddTableName()){
                fileName=template.getPrefix() + tableSchema.getEntityName() + template.getPostfix();
            }else{
                fileName=template.getPrefix()+ template.getPostfix();
            }
            if(template.isPathAddEntity()){
//                outFilePath = module.getFullOutpath() + template.getPath() + File.separator + tableSchema.getEntityName() + File.separator + fileName;
                outFilePath = module.getFullOutpath() + template.getPath() + File.separator + tableSchema.getName() + File.separator + fileName;
            }else{
                outFilePath = module.getFullOutpath() + template.getPath() + File.separator + fileName;
            }

        }
        File file = new File(outFilePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
//        URL resource = this.getClass().getResource(template.getTemplatePath());
//        String path=  resource.getFile();
//        if(path.startsWith("/")){
//            path =path.substring(1);
//        }
        System.out.println("build file -->> " + outFilePath);

        if(customTemplatPath.length()>0){
            ClassPathResource classPathResource = new ClassPathResource(customTemplatPath+template.getTemplatePath());
            if(classPathResource.exists()){
                return write(customTemplatPath+template.getTemplatePath(), outFilePath, model);
            }
        }
        return write(defaultTemplatPath+ template.getTemplatePath(), outFilePath, model);
    }
}
