/*
 * Copyright (c) 2011-2021, baomidou (jobob@qq.com).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package cn.net.vidyo.framework.builder.domain;

/**
 * 表字段类型
 *
 * @author hubin
 * @since 2017-01-11
 */
public enum DbColumnType implements IColumnType {
    // 基本类型
    BASE_BYTE("byte", null,"new byte[0]","null","number"),
    BASE_SHORT("short", null,"0"),
    BASE_CHAR("char", null,"''"),
    BASE_INT("int", null,"0"),
    BASE_LONG("long", null,"0L","0","number"),
    BASE_FLOAT("float", null,"0"),
    BASE_DOUBLE("double", null,"0"),
    BASE_BOOLEAN("boolean", null,"false"),

    // 包装类型
    BYTE("Byte", null,"new byte[0]","null","number"),
    SHORT("Short", null,"0","0","number"),
    CHARACTER("Character", null,"\"\"","''","string"),
    INTEGER("Integer", null,"0","0","number"),
    LONG("Long", null,"0L","0","number"),
    FLOAT("Float", null,"0","0","number"),
    DOUBLE("Double", null,"0","0","number"),
    BOOLEAN("Boolean", null,"false","false","boolean"),
    STRING("String", null,"\"\"","''","string"),

    // sql 包下数据类型
    DATE_SQL("Date", "java.sql.Date","new java.sql.Date()"),
    TIME("Time", "java.sql.Time","new java.sql.Time()"),
    TIMESTAMP("Timestamp", "java.sql.Timestamp","new java.sql.Timestamp()"),
    BLOB("Blob", "java.sql.Blob","null"),
    CLOB("Clob", "java.sql.Clob","null"),

    // java8 新时间类型
    LOCAL_DATE("LocalDate", "java.time.LocalDate","java.time.LocalDate,now()"),
    LOCAL_TIME("LocalTime", "java.time.LocalTime","java.time.LocalTime.now()"),
    YEAR("Year", "java.time.Year","java.time.Year.now()"),
    YEAR_MONTH("YearMonth", "java.time.YearMonth","java.time.YearMonth.now()"),
    LOCAL_DATE_TIME("LocalDateTime", "java.time.LocalDateTime","java.time.LocalDateTime.now()"),
    INSTANT("Instant", "java.time.Instant","java.time.Instant.now()"),

    // 其他杂类
    MAP("Map", "java.util.Map","new java.util.HashMap()"),
    BYTE_ARRAY("byte[]", null,"new byte[0]"),
    OBJECT("Object", null,"null"),
    DATE("Date", "java.util.Date","new java.util.Date()"),
    BIG_INTEGER("BigInteger", "java.math.BigInteger","new java.math.BigInteger()"),
    BIG_DECIMAL("BigDecimal", "java.math.BigDecimal","new java.math.BigDecimal()");

    /**
     * 类型
     */
    private final String type;

    /**
     * 包路径
     */
    private final String pkg;
    private String defaultValue="";
    private String tsDefaultValue ="";
    private String tsType="";

    DbColumnType(String type, String pkg, String defaultValue) {
        this.type = type;
        this.pkg = pkg;
        this.defaultValue = defaultValue;
        this.tsDefaultValue = "";
        this.tsType="";
    }

    DbColumnType(String type, String pkg, String defaultValue, String tsdefaultValue,String tsType) {
        this.type = type;
        this.pkg = pkg;
        this.defaultValue = defaultValue;
        this.tsDefaultValue = tsdefaultValue;
        this.tsType=tsType;
    }

    DbColumnType(final String type, final String pkg) {
        this.type = type;
        this.pkg = pkg;
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public String getPkg() {
        return pkg;
    }
    @Override
    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getTsDefaultValue() {
        return tsDefaultValue;
    }

    public void setTsDefaultValue(String tsDefaultValue) {
        this.tsDefaultValue = tsDefaultValue;
    }

    @Override
    public String getTsType() {
        return tsType;
    }

    public void setTsType(String tsType) {
        this.tsType = tsType;
    }
}
