package cn.net.vidyo.framework.builder;

import cn.net.vidyo.framework.builder.build.DataSourceMetaBuildExecuter;
import cn.net.vidyo.framework.builder.build.DatabaseMetaBuildExecuter;
import cn.net.vidyo.framework.builder.build.ErStudioMetaBuildExecuter;
import cn.net.vidyo.framework.builder.config.DataSourceConfig;
import cn.net.vidyo.framework.builder.meta.DatabaseSchema;

public class DatabaseMetaBuilder implements DatabaseMetaBuildExecuter{
    DatabaseMetaBuildExecuter executer;

    public DatabaseMetaBuilder setDataSource(String url,String username,String password){
        DataSourceMetaBuildExecuter executer=new DataSourceMetaBuildExecuter();
        executer.setDataSource(url,username,password);
        this.executer=executer;
        return this;
    }
    public DatabaseMetaBuilder setErStudioFile(String fileName){
        ErStudioMetaBuildExecuter executer=new ErStudioMetaBuildExecuter();
        executer.setErStudioFile(fileName);
        this.executer=executer;
        return this;
    }
    public DatabaseSchema build(){
        return executer.build();
    }
}
