/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.util;

import cn.net.vidyo.framework.generate.gen.entity.TemplateConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public final class TemplateMetaUtils {
    private TemplateMetaUtils() {
    }

    public static Map<String, String> parseMetaContent(String content) {
        if ((content = StringUtils.trimLeadingWhitespace((String)content)) != null && content.startsWith("##")) {
            int rowIdx = content.indexOf(10);
            String metaInfo = content.substring(2, rowIdx);
            return TemplateMetaUtils.parseMetaRow(metaInfo);
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> parseMetaRow(String row) {
        String[] paris;
        HashMap<String, String> data = new HashMap<String, String>();
        for (String item : paris = row.split("\\s*,\\s*")) {
            String[] kv = item.split("=");
            data.put(kv[0].trim(), kv.length == 1 ? null : kv[1].trim());
        }
        return data;
    }

    public static String generateMetaContent(TemplateConfig template) {
        int rowIdx;
        String content = StringUtils.trimLeadingWhitespace((String)template.getContent());
        String metaRow = TemplateMetaUtils.generateMetaRow(template);
        content = content.startsWith("##") ? ((rowIdx = content.indexOf(10)) == -1 ? metaRow : metaRow + content.substring(rowIdx)) : metaRow + "\n" + content;
        return content;
    }

    public static String generateMetaRow(TemplateConfig template) {
        String format = "## filename=%s, folder=%s";
        String filename = template.getFileName() != null ? template.getFileName() : "";
        String folder = template.getFolder() != null ? template.getFolder() : "";
        return String.format(format, filename, folder);
    }
}

