/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.config;

import cn.net.vidyo.framework.common.util.ValueUtil;
import java.util.HashSet;
import java.util.Set;

public class StrategyConfig {
    private boolean isCapitalMode;
    private boolean skipView;
    private final Set<String> tablePrefix = new HashSet<String>();
    private final Set<String> tableSuffix = new HashSet<String>();
    private final Set<String> fieldPrefix = new HashSet<String>();
    private final Set<String> fieldSuffix = new HashSet<String>();
    private final Set<String> include = new HashSet<String>();
    private final Set<String> exclude = new HashSet<String>();
    private boolean enableSqlFilter = true;
    private boolean enableSchema;

    public boolean matchIncludeTable(String tableName) {
        return this.matchTable(tableName, this.getInclude());
    }

    public boolean matchExcludeTable(String tableName) {
        return this.matchTable(tableName, this.getExclude());
    }

    private boolean matchTable(String tableName, Set<String> matchTables) {
        return matchTables.stream().anyMatch(t -> this.tableNameMatches((String)t, tableName));
    }

    private boolean tableNameMatches(String matchTableName, String dbTableName) {
        return matchTableName.equalsIgnoreCase(dbTableName) || ValueUtil.matches((String)matchTableName, (String)dbTableName);
    }

    public boolean isCapitalMode() {
        return this.isCapitalMode;
    }

    public boolean isSkipView() {
        return this.skipView;
    }

    public Set<String> getTablePrefix() {
        return this.tablePrefix;
    }

    public Set<String> getTableSuffix() {
        return this.tableSuffix;
    }

    public Set<String> getFieldPrefix() {
        return this.fieldPrefix;
    }

    public Set<String> getFieldSuffix() {
        return this.fieldSuffix;
    }

    public Set<String> getInclude() {
        return this.include;
    }

    public Set<String> getExclude() {
        return this.exclude;
    }

    public boolean isEnableSqlFilter() {
        return this.enableSqlFilter;
    }

    public boolean isEnableSchema() {
        return this.enableSchema;
    }

    public void setCapitalMode(boolean isCapitalMode) {
        this.isCapitalMode = isCapitalMode;
    }

    public void setSkipView(boolean skipView) {
        this.skipView = skipView;
    }

    public void setEnableSqlFilter(boolean enableSqlFilter) {
        this.enableSqlFilter = enableSqlFilter;
    }

    public void setEnableSchema(boolean enableSchema) {
        this.enableSchema = enableSchema;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StrategyConfig)) {
            return false;
        }
        StrategyConfig other = (StrategyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCapitalMode() != other.isCapitalMode()) {
            return false;
        }
        if (this.isSkipView() != other.isSkipView()) {
            return false;
        }
        Set<String> this$tablePrefix = this.getTablePrefix();
        Set<String> other$tablePrefix = other.getTablePrefix();
        if (this$tablePrefix == null ? other$tablePrefix != null : !((Object)this$tablePrefix).equals(other$tablePrefix)) {
            return false;
        }
        Set<String> this$tableSuffix = this.getTableSuffix();
        Set<String> other$tableSuffix = other.getTableSuffix();
        if (this$tableSuffix == null ? other$tableSuffix != null : !((Object)this$tableSuffix).equals(other$tableSuffix)) {
            return false;
        }
        Set<String> this$fieldPrefix = this.getFieldPrefix();
        Set<String> other$fieldPrefix = other.getFieldPrefix();
        if (this$fieldPrefix == null ? other$fieldPrefix != null : !((Object)this$fieldPrefix).equals(other$fieldPrefix)) {
            return false;
        }
        Set<String> this$fieldSuffix = this.getFieldSuffix();
        Set<String> other$fieldSuffix = other.getFieldSuffix();
        if (this$fieldSuffix == null ? other$fieldSuffix != null : !((Object)this$fieldSuffix).equals(other$fieldSuffix)) {
            return false;
        }
        Set<String> this$include = this.getInclude();
        Set<String> other$include = other.getInclude();
        if (this$include == null ? other$include != null : !((Object)this$include).equals(other$include)) {
            return false;
        }
        Set<String> this$exclude = this.getExclude();
        Set<String> other$exclude = other.getExclude();
        if (this$exclude == null ? other$exclude != null : !((Object)this$exclude).equals(other$exclude)) {
            return false;
        }
        if (this.isEnableSqlFilter() != other.isEnableSqlFilter()) {
            return false;
        }
        return this.isEnableSchema() == other.isEnableSchema();
    }

    protected boolean canEqual(Object other) {
        return other instanceof StrategyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCapitalMode() ? 79 : 97);
        result = result * 59 + (this.isSkipView() ? 79 : 97);
        Set<String> $tablePrefix = this.getTablePrefix();
        result = result * 59 + ($tablePrefix == null ? 43 : ((Object)$tablePrefix).hashCode());
        Set<String> $tableSuffix = this.getTableSuffix();
        result = result * 59 + ($tableSuffix == null ? 43 : ((Object)$tableSuffix).hashCode());
        Set<String> $fieldPrefix = this.getFieldPrefix();
        result = result * 59 + ($fieldPrefix == null ? 43 : ((Object)$fieldPrefix).hashCode());
        Set<String> $fieldSuffix = this.getFieldSuffix();
        result = result * 59 + ($fieldSuffix == null ? 43 : ((Object)$fieldSuffix).hashCode());
        Set<String> $include = this.getInclude();
        result = result * 59 + ($include == null ? 43 : ((Object)$include).hashCode());
        Set<String> $exclude = this.getExclude();
        result = result * 59 + ($exclude == null ? 43 : ((Object)$exclude).hashCode());
        result = result * 59 + (this.isEnableSqlFilter() ? 79 : 97);
        result = result * 59 + (this.isEnableSchema() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "StrategyConfig(isCapitalMode=" + this.isCapitalMode() + ", skipView=" + this.isSkipView() + ", tablePrefix=" + this.getTablePrefix() + ", tableSuffix=" + this.getTableSuffix() + ", fieldPrefix=" + this.getFieldPrefix() + ", fieldSuffix=" + this.getFieldSuffix() + ", include=" + this.getInclude() + ", exclude=" + this.getExclude() + ", enableSqlFilter=" + this.isEnableSqlFilter() + ", enableSchema=" + this.isEnableSchema() + ")";
    }
}

