/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.config;

import cn.net.vidyo.framework.builder.converts.MySqlTypeConvert;
import cn.net.vidyo.framework.builder.converts.TypeConverts;
import cn.net.vidyo.framework.builder.domain.DbType;
import cn.net.vidyo.framework.builder.domain.IDbQuery;
import cn.net.vidyo.framework.builder.domain.ITypeConvert;
import cn.net.vidyo.framework.builder.querys.DbQueryRegistry;
import java.util.Optional;

public class DataSourceConfig {
    private String schemaName;
    private ITypeConvert typeConvert;
    private String url;
    private String username;
    private String password;
    private String dirverClassName;
    private IDbQuery dbQuery;

    public IDbQuery getDbQuery() {
        if (null == this.dbQuery) {
            DbType dbType = this.getDbType();
            DbQueryRegistry dbQueryRegistry = new DbQueryRegistry();
            this.dbQuery = Optional.ofNullable(dbQueryRegistry.getDbQuery(dbType)).orElseGet(() -> dbQueryRegistry.getDbQuery(DbType.MYSQL));
        }
        return this.dbQuery;
    }

    public DbType getDbType() {
        return this.getDbType(this.url.toLowerCase());
    }

    private DbType getDbType(String str) {
        if (str.contains(":mysql:") || str.contains(":cobar:")) {
            return DbType.MYSQL;
        }
        if (str.contains(":oracle:")) {
            return DbType.ORACLE;
        }
        if (str.contains(":postgresql:")) {
            return DbType.POSTGRE_SQL;
        }
        if (str.contains(":sqlserver:")) {
            return DbType.SQL_SERVER;
        }
        if (str.contains(":db2:")) {
            return DbType.DB2;
        }
        if (str.contains(":mariadb:")) {
            return DbType.MARIADB;
        }
        if (str.contains(":sqlite:")) {
            return DbType.SQLITE;
        }
        if (str.contains(":h2:")) {
            return DbType.H2;
        }
        if (str.contains(":kingbase:") || str.contains(":kingbase8:")) {
            return DbType.KINGBASE_ES;
        }
        if (str.contains(":dm:")) {
            return DbType.DM;
        }
        if (str.contains(":zenith:")) {
            return DbType.GAUSS;
        }
        if (str.contains(":oscar:")) {
            return DbType.OSCAR;
        }
        if (str.contains(":firebird:")) {
            return DbType.FIREBIRD;
        }
        if (str.contains(":xugu:")) {
            return DbType.XU_GU;
        }
        if (str.contains(":clickhouse:")) {
            return DbType.CLICK_HOUSE;
        }
        if (str.contains(":sybase:")) {
            return DbType.SYBASE;
        }
        return DbType.OTHER;
    }

    public ITypeConvert getTypeConvert() {
        if (null == this.typeConvert) {
            DbType dbType = this.getDbType();
            this.typeConvert = TypeConverts.getTypeConvert(dbType);
            if (null == this.typeConvert) {
                this.typeConvert = MySqlTypeConvert.INSTANCE;
            }
        }
        return this.typeConvert;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDirverClassName() {
        return this.dirverClassName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTypeConvert(ITypeConvert typeConvert) {
        this.typeConvert = typeConvert;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDirverClassName(String dirverClassName) {
        this.dirverClassName = dirverClassName;
    }

    public void setDbQuery(IDbQuery dbQuery) {
        this.dbQuery = dbQuery;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceConfig)) {
            return false;
        }
        DataSourceConfig other = (DataSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        ITypeConvert this$typeConvert = this.getTypeConvert();
        ITypeConvert other$typeConvert = other.getTypeConvert();
        if (this$typeConvert == null ? other$typeConvert != null : !this$typeConvert.equals(other$typeConvert)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$dirverClassName = this.getDirverClassName();
        String other$dirverClassName = other.getDirverClassName();
        if (this$dirverClassName == null ? other$dirverClassName != null : !this$dirverClassName.equals(other$dirverClassName)) {
            return false;
        }
        IDbQuery this$dbQuery = this.getDbQuery();
        IDbQuery other$dbQuery = other.getDbQuery();
        return !(this$dbQuery == null ? other$dbQuery != null : !this$dbQuery.equals(other$dbQuery));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        ITypeConvert $typeConvert = this.getTypeConvert();
        result = result * 59 + ($typeConvert == null ? 43 : $typeConvert.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $dirverClassName = this.getDirverClassName();
        result = result * 59 + ($dirverClassName == null ? 43 : $dirverClassName.hashCode());
        IDbQuery $dbQuery = this.getDbQuery();
        result = result * 59 + ($dbQuery == null ? 43 : $dbQuery.hashCode());
        return result;
    }

    public String toString() {
        return "DataSourceConfig(schemaName=" + this.getSchemaName() + ", typeConvert=" + this.getTypeConvert() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", dirverClassName=" + this.getDirverClassName() + ", dbQuery=" + this.getDbQuery() + ")";
    }
}

