/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder;

import cn.net.vidyo.framework.builder.TemplateModel;
import cn.net.vidyo.framework.builder.config.GlobalConfig;
import cn.net.vidyo.framework.builder.engine.FreemakerTemplateEngine;
import cn.net.vidyo.framework.builder.meta.DatabaseSchema;
import cn.net.vidyo.framework.builder.meta.TableSchema;
import cn.net.vidyo.framework.builder.query.DefaultDatabaseQuery;
import cn.net.vidyo.framework.builder.template.ITemplate;
import java.util.List;

public class Builder {
    public void gen(GlobalConfig globalConfig) {
        DefaultDatabaseQuery defaultDatabaseQuery = new DefaultDatabaseQuery(globalConfig);
        List<TableSchema> tableSchemas = defaultDatabaseQuery.queryTables();
        DatabaseSchema databaseSchema = new DatabaseSchema();
        databaseSchema.setTables(tableSchemas);
        TemplateModel model = new TemplateModel();
        model.setConfig(globalConfig);
        model.setDatabase(databaseSchema);
        model.getExtend().setModel(model);
        model.getExtend().setConfig(globalConfig);
        FreemakerTemplateEngine engine = new FreemakerTemplateEngine();
        engine.init();
        for (TableSchema tableSchema : tableSchemas) {
            model.setTable(tableSchema);
            model.getExtend().setTable(tableSchema);
            for (ITemplate template : globalConfig.getTemplateConfig().getTemplateMap().values()) {
                model.getModel().put("basenamespace", globalConfig.getNamespace());
                model.getModel().put("templatenamespace", globalConfig.getNamespace());
                model.getModel().put("namespace", globalConfig.getNamespace() + template.getNamespace());
                model.getModel().put("entityName", tableSchema.getFirstLetterName());
                boolean bl = engine.write(globalConfig, template, (Object)model);
            }
        }
        System.out.println(tableSchemas);
    }
}

