/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.util;

import java.util.Objects;
import org.springframework.util.StringUtils;

public class FieldUtil {
    public static final String UNDER_LINE = "_";

    public static String underlineFilter(String field) {
        if (StringUtils.hasText((String)field)) {
            char underLine = '_';
            int underLineCountLeading = FieldUtil.findCharCount(field, underLine, false);
            int underLineCountTailing = FieldUtil.findCharCount(field, underLine, true);
            field = StringUtils.trimLeadingCharacter((String)field, (char)underLine);
            if (FieldUtil.isSingleAllUpper(field = StringUtils.trimTrailingCharacter((String)field, (char)underLine))) {
                return field.toLowerCase();
            }
            if (field.contains(UNDER_LINE)) {
                field = field.toLowerCase();
            }
            String[] arr = field.split("_+");
            return FieldUtil.join(arr, underLineCountLeading, underLineCountTailing);
        }
        return "";
    }

    private static boolean isSingleAllUpper(String name) {
        if (name.contains(UNDER_LINE)) {
            return false;
        }
        return Objects.equals(name, name.toUpperCase());
    }

    private static String join(String[] arr, int underLineCountLeading, int underLineCountTailing) {
        int i;
        if (arr.length > 1) {
            for (int i2 = 1; i2 < arr.length; ++i2) {
                arr[i2] = FieldUtil.upperFirstLetter(arr[i2]);
            }
        }
        StringBuilder ret = new StringBuilder();
        char underLine = '_';
        for (i = 0; i < underLineCountLeading; ++i) {
            ret.append(underLine);
        }
        ret.append(String.join((CharSequence)"", arr));
        for (i = 0; i < underLineCountTailing; ++i) {
            ret.append(underLine);
        }
        return ret.toString();
    }

    private static int findCharCount(String str, char searchChar, boolean reverse) {
        if (StringUtils.isEmpty((Object)str)) {
            return 0;
        }
        int count = 0;
        char[] chars = str.toCharArray();
        if (reverse) {
            for (int i = chars.length - 1; i >= 0 && chars[i] == searchChar; --i) {
                ++count;
            }
        } else {
            for (char aChar : chars) {
                if (aChar != searchChar) break;
                ++count;
            }
        }
        return count;
    }

    public static String convertString(Object object) {
        if (object == null) {
            return "";
        }
        return String.valueOf(object);
    }

    public static String dotFilter(String field) {
        if (StringUtils.hasText((String)field) && field.contains(".")) {
            String[] words = field.split("\\.");
            StringBuilder ret = new StringBuilder();
            for (String str : words) {
                ret.append(FieldUtil.upperFirstLetter(str));
            }
            return ret.toString();
        }
        return field;
    }

    public static String upperFirstLetter(String str) {
        if (StringUtils.hasText((String)str)) {
            String firstUpper = str.substring(0, 1).toUpperCase();
            str = firstUpper + str.substring(1);
        }
        return str;
    }

    public static String lowerFirstLetter(String str) {
        if (StringUtils.hasText((String)str)) {
            String firstLower = str.substring(0, 1).toLowerCase();
            str = firstLower + str.substring(1);
        }
        return str;
    }
}

