/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen.sqlserver;

import cn.net.vidyo.framework.generate.gen.ColumnDefinition;
import cn.net.vidyo.framework.generate.gen.ColumnSelector;
import cn.net.vidyo.framework.generate.gen.GeneratorConfig;
import cn.net.vidyo.framework.generate.gen.sqlserver.SqlServerTypeFormatter;
import cn.net.vidyo.framework.generate.util.FieldUtil;
import java.util.Map;
import java.util.Set;
import org.springframework.util.StringUtils;

public class SqlServerColumnSelector
extends ColumnSelector {
    private static final SqlServerTypeFormatter TYPE_FORMATTER = new SqlServerTypeFormatter();
    private static String TABKE_DETAIL_SQL = "SELECT" + "\t col.name AS column_name" + "\t, col.max_length AS MaxLength" + "\t, col.scale AS Scale" + "\t, col.is_nullable AS NULLABLE" + "\t, bt.name AS type" + "\t, col.is_identity" + "\t, ext.value AS comment" + "\t,(" + "\t\tSELECT COUNT(1) FROM sys.indexes IDX " + "\t\tINNER JOIN sys.index_columns IDXC " + "\t\tON IDX.[object_id]=IDXC.[object_id] " + "\t\tAND IDX.index_id=IDXC.index_id " + "\t\tLEFT JOIN sys.key_constraints KC " + "\t\tON IDX.[object_id]=KC.[parent_object_id] " + "\t\tAND IDX.index_id=KC.unique_index_id " + "\t\tINNER JOIN sys.objects O " + "\t\tON O.[object_id]=IDX.[object_id] " + "\t\tWHERE O.[object_id]=col.[object_id] " + "\t\tAND O.type='U' " + "\t\tAND O.is_ms_shipped=0 " + "\t\tAND IDX.is_primary_key=1 " + "\t\tAND IDXC.Column_id=col.column_id " + "\t) AS is_pk " + "FROM sys.columns col " + "LEFT OUTER JOIN sys.types bt on bt.user_type_id = col.system_type_id " + "LEFT JOIN sys.extended_properties ext ON ext.major_id = col.object_id AND ext.minor_id = col.column_id " + "WHERE col.object_id = object_id('%s') " + "ORDER BY col.column_id";

    public SqlServerColumnSelector(GeneratorConfig generatorConfig) {
        super(generatorConfig);
    }

    @Override
    protected String getColumnInfoSQL(String tableName) {
        return String.format(TABKE_DETAIL_SQL, tableName);
    }

    @Override
    protected ColumnDefinition buildColumnDefinition(Map<String, Object> rowMap) {
        Set<String> columnSet = rowMap.keySet();
        for (String columnInfo : columnSet) {
            rowMap.put(columnInfo.toUpperCase(), rowMap.get(columnInfo));
        }
        ColumnDefinition columnDefinition = new ColumnDefinition();
        columnDefinition.setColumnName(FieldUtil.convertString(rowMap.get("COLUMN_NAME")));
        columnDefinition.setIsIdentity((Boolean)rowMap.get("IS_IDENTITY"));
        boolean isPk = (Integer)rowMap.get("IS_PK") == 1;
        columnDefinition.setIsPk(isPk);
        String type = FieldUtil.convertString(rowMap.get("TYPE"));
        columnDefinition.setType(TYPE_FORMATTER.format(type));
        columnDefinition.setComment(FieldUtil.convertString(rowMap.get("COMMENT")));
        String maxLength = FieldUtil.convertString(rowMap.get("MAXLENGTH"));
        columnDefinition.setMaxLength(Integer.parseInt(StringUtils.isEmpty((Object)maxLength) ? "0" : maxLength));
        String scale = FieldUtil.convertString(rowMap.get("SCALE"));
        columnDefinition.setScale(Integer.parseInt(StringUtils.isEmpty((Object)scale) ? "0" : scale));
        String isNullable = FieldUtil.convertString(rowMap.get("NULLABLE"));
        columnDefinition.setIsNullable("1".equalsIgnoreCase(isNullable));
        return columnDefinition;
    }
}

