/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen.postgresql;

import cn.net.vidyo.framework.generate.gen.ColumnDefinition;
import cn.net.vidyo.framework.generate.gen.ColumnSelector;
import cn.net.vidyo.framework.generate.gen.GeneratorConfig;
import cn.net.vidyo.framework.generate.gen.postgresql.PostgreSqlTypeFormatter;
import cn.net.vidyo.framework.generate.util.FieldUtil;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class PostgreSqlColumnSelector
extends ColumnSelector {
    private static final PostgreSqlTypeFormatter SQL_TYPE_FORMATTER = new PostgreSqlTypeFormatter();
    private static final String SHOW_COLUMN_SQL = "SELECT   pg_attribute.attname AS colname,   atttypid::regtype AS type,   numeric_scale as SCALE,   C.is_nullable as NULLABLE,   col_description ( pg_attribute.attrelid, pg_attribute.attnum ) AS cmt,   pg_attribute.attnum = pg_constraint.conkey [ 1 ] AS is_pk,  CASE WHEN POSITION ( 'nextval' IN column_default ) > 0 THEN 1 ELSE 0 END AS is_identity  FROM   pg_constraint   RIGHT JOIN pg_class ON pg_constraint.conrelid = pg_class.oid   RIGHT JOIN pg_attribute ON pg_attribute.attrelid = pg_class.oid   RIGHT JOIN pg_type ON pg_type.oid = pg_attribute.atttypid   RIGHT JOIN information_schema.COLUMNS C ON C.TABLE_NAME = pg_class.relname    AND C.COLUMN_NAME = pg_attribute.attname   WHERE   pg_class.relname = '%s'  AND pg_attribute.attnum > 0";

    public PostgreSqlColumnSelector(GeneratorConfig dataBaseConfig) {
        super(dataBaseConfig);
    }

    @Override
    protected String getColumnInfoSQL(String tableName) {
        return String.format(SHOW_COLUMN_SQL, tableName);
    }

    @Override
    protected ColumnDefinition buildColumnDefinition(Map<String, Object> rowMap) {
        Set<String> columnSet = rowMap.keySet();
        for (String columnInfo : columnSet) {
            rowMap.put(columnInfo.toUpperCase(), rowMap.get(columnInfo));
        }
        ColumnDefinition columnDefinition = new ColumnDefinition();
        columnDefinition.setColumnName(FieldUtil.convertString(rowMap.get("COLNAME")));
        boolean isIdentity = "1".equals(FieldUtil.convertString(rowMap.get("IS_IDENTITY")));
        columnDefinition.setIsIdentity(isIdentity);
        boolean isPk = (Boolean)(rowMap.get("IS_PK") != null ? rowMap.get("IS_PK") : Boolean.valueOf(false));
        columnDefinition.setIsPk(isPk);
        String type = FieldUtil.convertString(rowMap.get("TYPE"));
        if (StringUtils.containsIgnoreCase((String)type, (String)"numeric")) {
            String scale;
            Object scaleCol = rowMap.get("SCALE");
            if (scaleCol == null) {
                scaleCol = 0;
            }
            type = "0".equals(scale = String.valueOf(scaleCol)) ? "integer" : "decimal";
        }
        columnDefinition.setType(SQL_TYPE_FORMATTER.format(type));
        columnDefinition.setComment(FieldUtil.convertString(rowMap.get("CMT")));
        String isNullable = FieldUtil.convertString(rowMap.get("NULLABLE"));
        columnDefinition.setIsNullable(!"NO".equalsIgnoreCase(isNullable));
        return columnDefinition;
    }
}

