/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen.oracle;

import cn.net.vidyo.framework.generate.gen.ColumnSelector;
import cn.net.vidyo.framework.generate.gen.GeneratorConfig;
import cn.net.vidyo.framework.generate.gen.TableDefinition;
import cn.net.vidyo.framework.generate.gen.TableSelector;
import cn.net.vidyo.framework.generate.util.FieldUtil;
import java.util.Map;

public class OracleTableSelector
extends TableSelector {
    public OracleTableSelector(ColumnSelector columnSelector, GeneratorConfig dataBaseConfig) {
        super(columnSelector, dataBaseConfig);
    }

    @Override
    protected String getShowTablesSQL(GeneratorConfig generatorConfig) {
        String owner = generatorConfig.getSchemaName().toUpperCase();
        StringBuilder sb = new StringBuilder("");
        sb.append(" SELECT TABLE_NAME AS NAME, COMMENTS FROM all_tab_comments ");
        sb.append(" WHERE 1=1 ");
        if (this.getSchTableNames() != null && this.getSchTableNames().size() > 0) {
            StringBuilder tables = new StringBuilder();
            for (String table : this.getSchTableNames()) {
                tables.append(",'").append(table).append("'");
            }
            sb.append(" AND TABLE_NAME IN (" + tables.substring(1) + ")");
        }
        sb.append(" AND OWNER='" + owner + "'");
        return sb.toString();
    }

    @Override
    protected TableDefinition buildTableDefinition(Map<String, Object> tableMap) {
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setTableName(FieldUtil.convertString(tableMap.get("NAME")));
        tableDefinition.setComment(FieldUtil.convertString(tableMap.get("COMMENTS")));
        return tableDefinition;
    }
}

