/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen;

import cn.net.vidyo.framework.generate.gen.ColumnDefinition;
import cn.net.vidyo.framework.generate.gen.CsharpColumnDefinition;
import cn.net.vidyo.framework.generate.gen.JavaColumnDefinition;
import cn.net.vidyo.framework.generate.gen.TypeEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class TableDefinition {
    private String schema;
    private String tableName;
    private String comment;
    private transient List<ColumnDefinition> columnDefinitions = Collections.emptyList();
    private transient List<CsharpColumnDefinition> csharpColumnDefinitions = Collections.emptyList();

    public TableDefinition() {
    }

    public TableDefinition(String tableName) {
        this.tableName = tableName;
    }

    public boolean getHasDateColumn() {
        for (ColumnDefinition definition : this.columnDefinitions) {
            if (!TypeEnum.DATETIME.getType().equalsIgnoreCase(definition.getType())) continue;
            return true;
        }
        return false;
    }

    public boolean getHasDateField() {
        for (ColumnDefinition definition : this.columnDefinitions) {
            if (!Date.class.getSimpleName().equals(((JavaColumnDefinition)definition).getJavaType())) continue;
            return true;
        }
        return false;
    }

    public boolean getHasLocalDateField() {
        for (ColumnDefinition definition : this.columnDefinitions) {
            if (!LocalDate.class.getSimpleName().equals(((JavaColumnDefinition)definition).getJavaType())) continue;
            return true;
        }
        return false;
    }

    public boolean getHasLocalDateTimeField() {
        for (ColumnDefinition definition : this.columnDefinitions) {
            if (!LocalDateTime.class.getSimpleName().equals(((JavaColumnDefinition)definition).getJavaType())) continue;
            return true;
        }
        return false;
    }

    public boolean getHasBigDecimalField() {
        for (ColumnDefinition definition : this.columnDefinitions) {
            if (!"BigDecimal".equals(((JavaColumnDefinition)definition).getJavaType())) continue;
            return true;
        }
        return false;
    }

    public boolean getHasJsonbField() {
        for (ColumnDefinition definition : this.columnDefinitions) {
            if (!"jsonb".equals(definition.getType())) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public ColumnDefinition getPkColumn() {
        ColumnDefinition pk = null;
        for (ColumnDefinition column : this.columnDefinitions) {
            if (column.getColumnName().equalsIgnoreCase("id")) {
                pk = column;
            }
            if (!column.getIsPk().booleanValue()) continue;
            return column;
        }
        return pk;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public void setColumnDefinitions(List<ColumnDefinition> columnDefinitions) {
        this.columnDefinitions = columnDefinitions;
    }

    public List<CsharpColumnDefinition> getCsharpColumnDefinitions() {
        return this.csharpColumnDefinitions;
    }

    public void setCsharpColumnDefinitions(List<CsharpColumnDefinition> csharpColumnDefinitions) {
        this.csharpColumnDefinitions = csharpColumnDefinitions;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

