/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen;

import cn.net.vidyo.framework.generate.gen.DbType;
import cn.net.vidyo.framework.generate.gen.entity.DatasourceConfig;
import cn.net.vidyo.framework.generate.gen.entity.TemplateConfig;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;

public class GeneratorConfig {
    private Integer dbType;
    private String dbName;
    private String schemaName;
    private String host;
    private Integer port;
    private String username;
    private String password;
    List<TemplateConfig> templateConfigs = new ArrayList<TemplateConfig>();

    public GeneratorConfig addTemplateConfig(TemplateConfig ... configs) {
        for (TemplateConfig config : configs) {
            this.templateConfigs.add(config);
        }
        return this;
    }

    public TemplateConfig getTemplateConfigById(Object id) {
        for (TemplateConfig templateConfig : this.templateConfigs) {
            if (!templateConfig.getId().equals(id)) continue;
            return templateConfig;
        }
        return null;
    }

    public static GeneratorConfig build(DatasourceConfig datasourceConfig) {
        GeneratorConfig generatorConfig = new GeneratorConfig();
        BeanUtils.copyProperties((Object)datasourceConfig, (Object)generatorConfig);
        return generatorConfig;
    }

    public String getDriverClass() {
        DbType dbType = DbType.of(this.dbType);
        if (dbType == null) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u6570\u636e\u5e93\u7c7b\u578b" + this.dbType + "\uff0c\u8bf7\u5728DbType.java\u4e2d\u914d\u7f6e");
        }
        return dbType.getDriverClass();
    }

    public String getJdbcUrl() {
        DbType dbType = DbType.of(this.dbType);
        if (dbType == null) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u6570\u636e\u5e93\u7c7b\u578b" + this.dbType + "\uff0c\u8bf7\u5728DbType.java\u4e2d\u914d\u7f6e");
        }
        String jdbcUrl = dbType.getJdbcUrl();
        return String.format(jdbcUrl, this.host, this.port, this.dbName);
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public Integer getDbType() {
        return this.dbType;
    }

    public void setDbType(Integer dbType) {
        this.dbType = dbType;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }
}

