/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen;

import cn.net.vidyo.framework.generate.gen.GeneratorConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceManager {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceManager.class);
    private static final Map<String, DataSource> DATA_SOURCE_MAP = new ConcurrentHashMap<String, DataSource>(16);
    private static final ThreadLocal<Connection> CONNECTION_LOCAL = new ThreadLocal();

    public static Connection getConnection(GeneratorConfig generatorConfig) {
        Connection connection = CONNECTION_LOCAL.get();
        if (connection == null) {
            try {
                connection = DataSourceManager.getDataSource(generatorConfig).getConnection();
                CONNECTION_LOCAL.set(connection);
            }
            catch (SQLException e) {
                logger.error("\u83b7\u53d6Connection\u5931\u8d25, jdbcUrl:{}", (Object)generatorConfig.getJdbcUrl(), (Object)e);
                throw new RuntimeException("\u83b7\u53d6Connection\u5931\u8d25", e);
            }
        }
        return connection;
    }

    public static void closeConnection() {
        Connection connection = CONNECTION_LOCAL.get();
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        CONNECTION_LOCAL.remove();
    }

    public static DataSource getDataSource(GeneratorConfig generatorConfig) {
        String jdbcUrl = generatorConfig.getJdbcUrl() + ":" + generatorConfig.getUsername();
        DataSource dataSource = DATA_SOURCE_MAP.computeIfAbsent(jdbcUrl, key -> {
            Properties properties = new Properties();
            properties.put("driverClassName", generatorConfig.getDriverClass());
            properties.put("url", generatorConfig.getJdbcUrl());
            properties.put("username", generatorConfig.getUsername());
            properties.put("password", generatorConfig.getPassword());
            properties.put("initialSize", (Object)1);
            properties.put("maxTotal", (Object)30);
            properties.put("minIdle", (Object)5);
            properties.put("maxIdle", (Object)10);
            properties.put("maxWaitMillis", (Object)1000);
            properties.put("removeAbandonedOnMaintenance", (Object)true);
            properties.put("removeAbandonedOnBorrow", (Object)true);
            properties.put("removeAbandonedTimeout", (Object)5);
            try {
                return BasicDataSourceFactory.createDataSource((Properties)properties);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
        if (dataSource == null) {
            throw new RuntimeException("\u8fde\u63a5\u6570\u636e\u5e93\u5931\u8d25");
        }
        return dataSource;
    }
}

