/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public enum PropertiesManager {
    instance;

    private Map<String, Properties> propMap = new HashMap<String, Properties>();
    private String defProperties = "config.properties";

    public static PropertiesManager getInstance() {
        return instance;
    }

    private PropertiesManager() {
        this.loadProp(this.defProperties);
    }

    private Properties loadProp(String fileName) {
        Properties props = this.propMap.get(fileName);
        if (props == null) {
            ClassPathResource resource = new ClassPathResource(fileName);
            try {
                props = PropertiesLoaderUtils.loadProperties((Resource)resource);
                this.propMap.put(fileName, props);
            }
            catch (IOException e) {
                props = new Properties();
                e.printStackTrace();
            }
        }
        return props;
    }

    private String getValue(String key, String fileName) {
        Properties prop = this.propMap.get(fileName);
        if (prop == null) {
            prop = this.loadProp(fileName);
        }
        return prop.getProperty(key);
    }

    public String get(String key) {
        return this.getValue(key, this.defProperties);
    }

    public String get(String key, String fileName) {
        return this.getValue(key, fileName);
    }
}

