/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.dd.template;

import cn.net.vidyo.framework.dd.template.ITemplate;
import cn.net.vidyo.framework.dd.template.Template;
import cn.net.vidyo.framework.dd.template.TemplateType;
import java.util.LinkedList;
import java.util.List;

public class TemplateManager {
    List<ITemplate> templates = new LinkedList<ITemplate>();
    boolean exclude = false;
    List<String> excludeTemplateNames = new LinkedList<String>();

    public List<ITemplate> getTemplatesByType(TemplateType type) {
        LinkedList<ITemplate> list = new LinkedList<ITemplate>();
        for (ITemplate template : this.templates) {
            if (template.getType() != type) continue;
            list.add(template);
        }
        return list;
    }

    public TemplateManager addDefaultTemplates() {
        this.addTemplate(this.getDefaultEntityTemplate(), this.getDefaultDaoTemplate(), this.getDefaultMapperXmlTemplate(), this.getDefaultAutoServiceTemplate(), this.getDefaultAutoServiceImplTemplate(), this.getDefaultServiceTemplate(), this.getDefaultServiceImplTemplate(), this.getDefaultConditionTemplate(), this.getDefaultConverterTemplate(), this.getDefaultAutoControllerTemplate(), this.getDefaultUiApiTemplate());
        return this;
    }

    public ITemplate getDefaultEntityTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/entity.java.ftl");
        template.setName("entity");
        template.setPath("/service/data/entity");
        template.setNamespace(".data.entity");
        template.setPrefix("");
        template.setPostfix(".java");
        return template;
    }

    public ITemplate getDefaultDaoTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/dao.java.ftl");
        template.setName("dao");
        template.setPath("/service/data/auto/dao");
        template.setNamespace(".data.auto.dao");
        template.setPrefix("");
        template.setPostfix("Dao.java");
        return template;
    }

    public ITemplate getDefaultAutoServiceTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/autoservice.java.ftl");
        template.setName("autoservice");
        template.setPath("/service/data/auto/service");
        template.setNamespace(".data.auto.service");
        template.setPrefix("");
        template.setPostfix("AutoService.java");
        return template;
    }

    public ITemplate getDefaultAutoServiceImplTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/autoserviceImpl.java.ftl");
        template.setName("autoserviceImpl");
        template.setPath("/service/data/auto/service/impl");
        template.setNamespace(".data.auto.service.impl");
        template.setPrefix("");
        template.setPostfix("AutoServiceImpl.java");
        return template;
    }

    public ITemplate getDefaultServiceTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/service.java.ftl");
        template.setName("service");
        template.setPath("/service/data/service");
        template.setNamespace(".data.service");
        template.setPrefix("");
        template.setPostfix("Service.java");
        return template;
    }

    public ITemplate getDefaultServiceImplTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/serviceImpl.java.ftl");
        template.setName("serviceImpl");
        template.setPath("/service/data/service/impl");
        template.setNamespace(".data.service.impl");
        template.setPrefix("");
        template.setPostfix("ServiceImpl.java");
        return template;
    }

    public ITemplate getDefaultOneServiceTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/oneservice.java.ftl");
        template.setName("oneservice");
        template.setPath("/service/data/service");
        template.setNamespace(".data.service");
        template.setPrefix("");
        template.setPostfix("Service.java");
        return template;
    }

    public ITemplate getDefaultMapperXmlTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/mapper.xml.ftl");
        template.setName("mapper");
        template.setPath("/service/resources/mapper");
        template.setPrefix("");
        template.setPostfix("Mapper.xml");
        return template;
    }

    public ITemplate getDefaultConditionTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/condition.java.ftl");
        template.setName("condition");
        template.setPath("/service/data/condition");
        template.setNamespace(".data.condition");
        template.setPrefix("");
        template.setPostfix("Condition.java");
        return template;
    }

    public ITemplate getDefaultConverterTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/converter.java.ftl");
        template.setName("converter");
        template.setPath("/service/data/converter");
        template.setNamespace(".data.converter");
        template.setPrefix("");
        template.setPostfix("Converter.java");
        return template;
    }

    public ITemplate getDefaultAutoControllerTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/autocontroller.java.ftl");
        template.setName("autocontroller");
        template.setPath("/api/web/auto");
        template.setNamespace(".web.auto");
        template.setPrefix("");
        template.setPostfix("AutoController.java");
        return template;
    }

    public ITemplate getDefaultUiApiTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/web.ui.api.ts.ftl");
        template.setName("uiapi");
        template.setPath("/ui/src/api/auto");
        template.setNamespace(".web.ui.auto");
        template.setPrefix("");
        template.setPostfix(".ts");
        return template;
    }

    public TemplateManager addExcludeTemplateNames(boolean exclude, String ... names) {
        this.exclude = exclude;
        for (String s : names) {
            this.excludeTemplateNames.add(s);
        }
        return this;
    }

    public TemplateManager addTemplate(ITemplate ... templates) {
        for (ITemplate template : templates) {
            this.templates.add(template);
        }
        return this;
    }

    public List<ITemplate> getTemplates() {
        return this.templates;
    }

    public void setTemplates(List<ITemplate> templates) {
        this.templates = templates;
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public List<String> getExcludeTemplateNames() {
        return this.excludeTemplateNames;
    }

    public void setExcludeTemplateNames(List<String> excludeTemplateNames) {
        this.excludeTemplateNames = excludeTemplateNames;
    }
}

