/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.converts;

import cn.net.vidyo.framework.builder.converts.TypeConverts;
import cn.net.vidyo.framework.builder.domain.DateType;
import cn.net.vidyo.framework.builder.domain.DbColumnType;
import cn.net.vidyo.framework.builder.domain.IColumnType;
import cn.net.vidyo.framework.builder.domain.ITypeConvert;
import java.util.function.Function;

public class PostgreSqlTypeConvert
implements ITypeConvert {
    public static final PostgreSqlTypeConvert INSTANCE = new PostgreSqlTypeConvert();

    @Override
    public IColumnType processTypeConvert(DateType dateType, String fieldType) {
        return TypeConverts.use(fieldType).test(TypeConverts.containsAny("char", "text", "json", "enum").then(DbColumnType.STRING)).test(TypeConverts.contains("bigint").then(DbColumnType.LONG)).test(TypeConverts.contains("int").then(DbColumnType.INTEGER)).test(TypeConverts.containsAny("date", "time").then((IColumnType)((Object)((Function<String, IColumnType>)t -> PostgreSqlTypeConvert.toDateType(dateType, t))))).test(TypeConverts.contains("bit").then(DbColumnType.BOOLEAN)).test(TypeConverts.containsAny("decimal", "numeric").then(DbColumnType.BIG_DECIMAL)).test(TypeConverts.contains("bytea").then(DbColumnType.BYTE_ARRAY)).test(TypeConverts.contains("float").then(DbColumnType.FLOAT)).test(TypeConverts.contains("double").then(DbColumnType.DOUBLE)).test(TypeConverts.contains("boolean").then(DbColumnType.BOOLEAN)).or(DbColumnType.STRING);
    }

    public static IColumnType toDateType(DateType dateType, String type) {
        switch (dateType) {
            case SQL_PACK: {
                switch (type) {
                    case "date": {
                        return DbColumnType.DATE_SQL;
                    }
                    case "time": {
                        return DbColumnType.TIME;
                    }
                }
                return DbColumnType.TIMESTAMP;
            }
            case TIME_PACK: {
                switch (type) {
                    case "date": {
                        return DbColumnType.LOCAL_DATE;
                    }
                    case "time": {
                        return DbColumnType.LOCAL_TIME;
                    }
                }
                return DbColumnType.LOCAL_DATE_TIME;
            }
        }
        return DbColumnType.DATE;
    }
}

