/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.converts;

import cn.net.vidyo.framework.builder.converts.TypeConverts;
import cn.net.vidyo.framework.builder.domain.DateType;
import cn.net.vidyo.framework.builder.domain.DbColumnType;
import cn.net.vidyo.framework.builder.domain.IColumnType;
import cn.net.vidyo.framework.builder.domain.ITypeConvert;
import java.util.function.Function;

public class OracleTypeConvert
implements ITypeConvert {
    public static final OracleTypeConvert INSTANCE = new OracleTypeConvert();

    @Override
    public IColumnType processTypeConvert(DateType dateType, String fieldType) {
        return TypeConverts.use(fieldType).test(TypeConverts.containsAny("char", "clob").then(DbColumnType.STRING)).test(TypeConverts.containsAny("date", "timestamp").then((IColumnType)((Object)((Function<String, IColumnType>)p -> OracleTypeConvert.toDateType(dateType))))).test(TypeConverts.contains("number").then((IColumnType)((Object)((Function<String, IColumnType>)OracleTypeConvert::toNumberType)))).test(TypeConverts.contains("float").then(DbColumnType.FLOAT)).test(TypeConverts.contains("blob").then(DbColumnType.BLOB)).test(TypeConverts.containsAny("binary", "raw").then(DbColumnType.BYTE_ARRAY)).or(DbColumnType.STRING);
    }

    private static IColumnType toNumberType(String typeName) {
        if (typeName.matches("number\\([0-9]\\)")) {
            return DbColumnType.INTEGER;
        }
        if (typeName.matches("number\\(1[0-8]\\)")) {
            return DbColumnType.LONG;
        }
        return DbColumnType.BIG_DECIMAL;
    }

    protected static IColumnType toDateType(DateType dateType) {
        switch (dateType) {
            case ONLY_DATE: {
                return DbColumnType.DATE;
            }
            case SQL_PACK: {
                return DbColumnType.TIMESTAMP;
            }
            case TIME_PACK: {
                return DbColumnType.LOCAL_DATE_TIME;
            }
        }
        return DbColumnType.STRING;
    }
}

