/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.converts;

import cn.net.vidyo.framework.builder.converts.TypeConverts;
import cn.net.vidyo.framework.builder.domain.DateType;
import cn.net.vidyo.framework.builder.domain.DbColumnType;
import cn.net.vidyo.framework.builder.domain.IColumnType;
import cn.net.vidyo.framework.builder.domain.ITypeConvert;
import java.util.function.Function;

public class FirebirdTypeConvert
implements ITypeConvert {
    public static final FirebirdTypeConvert INSTANCE = new FirebirdTypeConvert();

    @Override
    public IColumnType processTypeConvert(DateType dateType, String fieldType) {
        return (IColumnType)((Object)TypeConverts.use(fieldType).test(TypeConverts.containsAny("cstring", "text").then(DbColumnType.STRING)).test(TypeConverts.contains("short").then(DbColumnType.SHORT)).test(TypeConverts.contains("long").then(DbColumnType.LONG)).test(TypeConverts.contains("float").then(DbColumnType.FLOAT)).test(TypeConverts.contains("double").then(DbColumnType.DOUBLE)).test(TypeConverts.contains("blob").then(DbColumnType.BLOB)).test(TypeConverts.contains("int64").then(DbColumnType.LONG)).test(TypeConverts.containsAny("date", "time", "year").then((IColumnType)((Object)((Function<String, IColumnType>)t -> FirebirdTypeConvert.toDateType(dateType, t))))).or((Function<String, IColumnType>)((Object)DbColumnType.STRING)));
    }

    public static IColumnType toDateType(DateType dateType, String type) {
        switch (dateType) {
            case ONLY_DATE: {
                return DbColumnType.DATE;
            }
            case SQL_PACK: {
                switch (type) {
                    case "date": 
                    case "year": {
                        return DbColumnType.DATE_SQL;
                    }
                    case "time": {
                        return DbColumnType.TIME;
                    }
                }
                return DbColumnType.TIMESTAMP;
            }
            case TIME_PACK: {
                switch (type) {
                    case "date": {
                        return DbColumnType.LOCAL_DATE;
                    }
                    case "time": {
                        return DbColumnType.LOCAL_TIME;
                    }
                    case "year": {
                        return DbColumnType.YEAR;
                    }
                }
                return DbColumnType.LOCAL_DATE_TIME;
            }
        }
        return DbColumnType.STRING;
    }
}

