/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.config;

import cn.net.vidyo.framework.common.util.ValueUtil;
import java.util.HashSet;
import java.util.Set;

public class StrategyConfig {
    private boolean isCapitalMode;
    private boolean skipView;
    private final Set<String> tablePrefix = new HashSet<String>();
    private final Set<String> tableSuffix = new HashSet<String>();
    private final Set<String> fieldPrefix = new HashSet<String>();
    private final Set<String> fieldSuffix = new HashSet<String>();
    private final Set<String> include = new HashSet<String>();
    private final Set<String> exclude = new HashSet<String>();
    private boolean enableSqlFilter = true;
    private boolean enableSchema;

    public boolean matchIncludeTable(String tableName) {
        return this.matchTable(tableName, this.getInclude());
    }

    public boolean matchExcludeTable(String tableName) {
        return this.matchTable(tableName, this.getExclude());
    }

    private boolean matchTable(String tableName, Set<String> matchTables) {
        return matchTables.stream().anyMatch(t -> this.tableNameMatches((String)t, tableName));
    }

    private boolean tableNameMatches(String matchTableName, String dbTableName) {
        return matchTableName.equalsIgnoreCase(dbTableName) || ValueUtil.matches((String)matchTableName, (String)dbTableName);
    }

    public boolean isCapitalMode() {
        return this.isCapitalMode;
    }

    public void setCapitalMode(boolean capitalMode) {
        this.isCapitalMode = capitalMode;
    }

    public boolean isSkipView() {
        return this.skipView;
    }

    public void setSkipView(boolean skipView) {
        this.skipView = skipView;
    }

    public Set<String> getTablePrefix() {
        return this.tablePrefix;
    }

    public Set<String> getTableSuffix() {
        return this.tableSuffix;
    }

    public Set<String> getFieldPrefix() {
        return this.fieldPrefix;
    }

    public Set<String> getFieldSuffix() {
        return this.fieldSuffix;
    }

    public Set<String> getInclude() {
        return this.include;
    }

    public Set<String> getExclude() {
        return this.exclude;
    }

    public boolean isEnableSqlFilter() {
        return this.enableSqlFilter;
    }

    public void setEnableSqlFilter(boolean enableSqlFilter) {
        this.enableSqlFilter = enableSqlFilter;
    }

    public boolean isEnableSchema() {
        return this.enableSchema;
    }

    public void setEnableSchema(boolean enableSchema) {
        this.enableSchema = enableSchema;
    }
}

