/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class SqlGenerator {
    public static Map<String, String> property2SqlColumnMap = new HashMap<String, String>();

    public static String generateSql(String className, String tableName, String primaryKey, String filePath) {
        try {
            Class<?> clz = Class.forName(className);
            className = clz.getSimpleName();
            Field[] fields = clz.getDeclaredFields();
            StringBuffer column = new StringBuffer();
            for (Field f : fields) {
                if (f.getName().equals(primaryKey)) continue;
                column.append(SqlGenerator.getColumnSql(f));
            }
            String sqlPrimaryKey = StringUtils.camelToUnderline((String)primaryKey).toUpperCase();
            StringBuffer sql = new StringBuffer();
            sql.append("\n DROP TABLE IF EXISTS `" + tableName + "`; ").append(" \n CREATE TABLE `" + tableName + "` (").append(" \n `" + sqlPrimaryKey + "` bigint(20) NOT NULL AUTO_INCREMENT,").append(" \n " + column).append(" \n PRIMARY KEY (`" + sqlPrimaryKey + "`)").append(" \n ) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci;");
            String sqlText = sql.toString();
            SqlGenerator.StringToSql(sqlText, filePath);
            return sqlText;
        }
        catch (ClassNotFoundException e) {
            System.out.println("SQL\u751f\u6210\u5f02\u5e38\uff1a" + e);
            return null;
        }
    }

    private static String getColumnSql(Field field) {
        String tpl = "\n `%s` %s DEFAULT NULL,";
        String typeName = field.getType().getSimpleName().toLowerCase();
        String sqlType = property2SqlColumnMap.get(typeName);
        if (sqlType == null || sqlType.isEmpty()) {
            System.out.println(field.getName() + ":" + field.getType().getName() + " \u9700\u8981\u5355\u72ec\u521b\u5efa\u8868");
            return "";
        }
        String column = StringUtils.camelToUnderline((String)field.getName()).toUpperCase();
        String sql = String.format(tpl, column, sqlType.toUpperCase());
        return sql;
    }

    private static void StringToSql(String str, String path) {
        byte[] sourceByte = str.getBytes();
        if (null != sourceByte) {
            try {
                File file = new File(path);
                if (!file.exists()) {
                    File dir = new File(file.getParent());
                    dir.mkdirs();
                    file.createNewFile();
                }
                FileOutputStream outStream = new FileOutputStream(file);
                outStream.write(sourceByte);
                outStream.flush();
                outStream.close();
                System.out.println("\u751f\u6210\u6210\u529f");
            }
            catch (Exception e) {
                System.out.println("\u4fdd\u5b58SQL\u6587\u4ef6\u5f02\u5e38\uff1a" + e);
            }
        }
    }

    static {
        property2SqlColumnMap.put("integer", "INT");
        property2SqlColumnMap.put("short", "tinyint");
        property2SqlColumnMap.put("long", "bigint");
        property2SqlColumnMap.put("bigdecimal", "decimal(19,2)");
        property2SqlColumnMap.put("double", "double precision not null");
        property2SqlColumnMap.put("float", "float");
        property2SqlColumnMap.put("boolean", "bit");
        property2SqlColumnMap.put("timestamp", "datetime");
        property2SqlColumnMap.put("date", "datetime");
        property2SqlColumnMap.put("string", "VARCHAR(256)");
    }
}

