/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder;

import cn.net.vidyo.framework.builder.meta.ColumnSchema;
import cn.net.vidyo.framework.builder.meta.DatabaseSchema;
import cn.net.vidyo.framework.builder.meta.TableSchema;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class DatabaseMetaDataUtil {
    public static DatabaseSchema queryDatabaseMetaData(String url, String userName, String password) {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            Connection con = DriverManager.getConnection(url, userName, password);
            DatabaseMetaData dbMetaData = con.getMetaData();
            return DatabaseMetaDataUtil.convertToSchema(dbMetaData);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DatabaseSchema convertToSchema(DatabaseMetaData dbMetaData) {
        DatabaseSchema databaseSchema = new DatabaseSchema();
        try {
            System.out.println("\u6570\u636e\u5e93\u5df2\u77e5\u7684\u7528\u6237: " + dbMetaData.getUserName());
            System.out.println("\u6570\u636e\u5e93\u7684\u7cfb\u7edf\u51fd\u6570\u7684\u9017\u53f7\u5206\u9694\u5217\u8868: " + dbMetaData.getSystemFunctions());
            System.out.println("\u6570\u636e\u5e93\u7684\u65f6\u95f4\u548c\u65e5\u671f\u51fd\u6570\u7684\u9017\u53f7\u5206\u9694\u5217\u8868: " + dbMetaData.getTimeDateFunctions());
            System.out.println("\u6570\u636e\u5e93\u7684\u5b57\u7b26\u4e32\u51fd\u6570\u7684\u9017\u53f7\u5206\u9694\u5217\u8868: " + dbMetaData.getStringFunctions());
            System.out.println("\u6570\u636e\u5e93\u4f9b\u5e94\u5546\u7528\u4e8e 'schema' \u7684\u9996\u9009\u672f\u8bed: " + dbMetaData.getSchemaTerm());
            System.out.println("\u6570\u636e\u5e93URL: " + dbMetaData.getURL());
            System.out.println("\u662f\u5426\u5141\u8bb8\u53ea\u8bfb:" + dbMetaData.isReadOnly());
            System.out.println("\u6570\u636e\u5e93\u7684\u4ea7\u54c1\u540d\u79f0:" + dbMetaData.getDatabaseProductName());
            System.out.println("\u6570\u636e\u5e93\u7684\u7248\u672c:" + dbMetaData.getDatabaseProductVersion());
            System.out.println("\u9a71\u52a8\u7a0b\u5e8f\u7684\u540d\u79f0:" + dbMetaData.getDriverName());
            System.out.println("\u9a71\u52a8\u7a0b\u5e8f\u7684\u7248\u672c:" + dbMetaData.getDriverVersion());
            System.out.println();
            ResultSet rs = dbMetaData.getSchemas();
            ArrayList<String> schemas = new ArrayList<String>();
            schemas.add("null");
            rs.close();
            for (String schema : schemas) {
                DatabaseMetaDataUtil.convertToDatabaseSchema(dbMetaData, databaseSchema, schema);
            }
            System.out.println();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return databaseSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void convertToDatabaseSchema(DatabaseMetaData dbMetaData, DatabaseSchema databaseSchema, String schemaName) {
        System.out.println("\u83b7\u53d6\u6240\u6709\u8868");
        String[] types = new String[]{"TABLE"};
        try {
            ResultSet rs = dbMetaData.getTables(null, schemaName, "%", types);
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String tableType = rs.getString("TABLE_TYPE");
                String schem = rs.getString("TABLE_SCHEM");
                String remarks = rs.getString("REMARKS");
                System.out.println("\u5904\u7406\u8868" + tableName);
                TableSchema tableSchema = new TableSchema();
                tableSchema.setName(tableName);
                tableSchema.setComment(remarks);
                tableSchema.setSchemaName(schemaName);
                DatabaseMetaDataUtil.convertToTableSchema(dbMetaData, tableSchema);
                databaseSchema.addTable(tableSchema);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    static void convertToTableSchema(DatabaseMetaData dbMetaData, TableSchema tableSchema) {
        try {
            ResultSet rs = dbMetaData.getColumns(null, tableSchema.getSchemaName(), tableSchema.getName(), "%");
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                String dataTypeName = rs.getString("TYPE_NAME");
                int columnSize = rs.getInt("COLUMN_SIZE");
                ColumnSchema columnSchema = new ColumnSchema();
                columnSchema.setName(columnName);
                columnSchema.setDataTypeName(dataTypeName);
                columnSchema.setLength(columnSize);
                columnSchema.convert();
                tableSchema.addColumn(columnSchema);
                if (columnName.equalsIgnoreCase("status")) {
                    System.out.println("Table " + tableSchema.getName() + " exist status");
                    tableSchema.setIncludeStatus(true);
                }
                if (!columnName.equalsIgnoreCase("name")) continue;
                System.out.println("Table " + tableSchema.getName() + " exist status");
                tableSchema.setIncludeName(true);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

