package cn.net.vidyo.framework.dd.config;

import java.util.LinkedList;
import java.util.List;

public class Project {
    String name="";
    String comment="";
    String outPath="";
    String namespace="'";
    List<Module> modules=new LinkedList<>();
    boolean exclude=false;
    List<String> excludeModuleNames=new LinkedList<>();

    public Project addModule(Module module){
        module.setFullNamespace(namespace+".");
        modules.add(module);
        return this;
    }
    public Project addExcludeModuleNames(boolean exclude, String... names){
        this.exclude=exclude;
        for (String s : names) {
            excludeModuleNames.add(s);
        }
        return this;
    }

    public List<Module> getModules() {
        return modules;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public boolean isExclude() {
        return exclude;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public List<String> getExcludeModuleNames() {
        return excludeModuleNames;
    }

    public void setExcludeModuleNames(List<String> excludeModuleNames) {
        this.excludeModuleNames = excludeModuleNames;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOutPath() {
        return outPath;
    }

    public void setOutPath(String outPath) {
        this.outPath = outPath;
    }

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}
