package cn.net.vidyo.framework.builder;

import cn.net.vidyo.framework.builder.config.*;
import cn.net.vidyo.framework.builder.config.Module;
import cn.net.vidyo.framework.builder.domain.IExtendHandler;
import cn.net.vidyo.framework.builder.engine.FreemakerTemplateEngine;
import cn.net.vidyo.framework.builder.meta.ColumnSchema;
import cn.net.vidyo.framework.builder.meta.TableSchema;
import cn.net.vidyo.framework.builder.database.query.DefaultDatabaseQuery;
import cn.net.vidyo.framework.builder.template.ITemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Generator2 {
    DataSourceConfig dataSourceConfig;
    List<IExtendHandler> extendHandlers=new ArrayList<>();

    public Generator2 setDataSource(String url, String username, String password){
        if(dataSourceConfig==null){
            dataSourceConfig=new DataSourceConfig();
        }
        dataSourceConfig.setUrl(url);
        dataSourceConfig.setUsername(username);
        dataSourceConfig.setPassword(password);
        return this;
    }

    public Generator2 addExtend(IExtendHandler... extendHandlers){
        for (IExtendHandler extendHandler : extendHandlers) {
            this.extendHandlers.add(extendHandler);
        }
        return this;
    }

    public void go(Project project){

        FreemakerTemplateEngine engine=new FreemakerTemplateEngine();
        engine.init();

        Map model=new HashMap();
        model.put(PROJECT,project);
        for (ProjectItem projectItem : project.getItems().toArray(new ProjectItem[0])) {
            cn.net.vidyo.framework.builder.config.Module module =(Module) projectItem;
            model.put(MODULE,module);
        }

        GlobalConfig globalConfig=new GlobalConfig();
        globalConfig.setDateType(project.getDateType());
        globalConfig.setDataSourceConfig(dataSourceConfig);
        DefaultDatabaseQuery defaultDatabaseQuery=new DefaultDatabaseQuery(globalConfig.getDataSourceConfig());
        List<TableSchema> tableSchemas = defaultDatabaseQuery.queryTables();
        for (TableSchema tableSchema : tableSchemas) {
            model.put(TABLE,tableSchema);
            if(tableSchema.getComment().length()==0){
                tableSchema.setComment(project.getAlias(tableSchema.getName()));
            }
            for (ColumnSchema columnSchema  : tableSchema.getColumns()) {
                if(columnSchema.getComment().length()==0){
                    columnSchema.setComment(project.getAlias(columnSchema.getName()));
                }
            }
            for (ProjectItem projectItem : project.getItems().toArray(new ProjectItem[0])) {
                Module module =(Module) projectItem;
                if(module.isExcludeTable(tableSchema.getName())){
                    continue;
                }
                model.put(MODULE,module);
                model.put("baseNamespace",module.getFullNamespace());
                model.put("entityNamespace",module.getFullNamespace()+".data.entity");
                model.put("conditionNamespace",module.getFullNamespace()+".data.condition");
                model.put("converterNamespace",module.getFullNamespace()+".data.converter");
                model.put("daoNamespace",module.getFullNamespace()+".data.auto.dao");
                model.put("autoServiceNamespace",module.getFullNamespace()+".data.auto.service");
                model.put("autoServiceImplNamespace",module.getFullNamespace()+".data.auto.service.impl");
                model.put("serviceNamespace",module.getFullNamespace()+".data.service");
                model.put("serviceImplNamespace",module.getFullNamespace()+".data.service.impl");
                model.put("controllerNamespace",module.getFullNamespace()+".web.auto");

                for (IExtendHandler extendHandler : extendHandlers) {
                    extendHandler.process(model,tableSchema,projectItem,module);
                }

                for (ITemplate template : module.getTemplateMap().values()) {
                    engine.write(globalConfig, template, model);
                }
            }
        }
    }


    public void test() {


    }


    //<editor-fold desc="KEYS">
    public static final String AUTHOR="author";
    public static final String NAMESPACE="namespace";
    public static final String OUT_PATH="outpath";
    public static final String PROJECT="project";
    public static final String MODULE="module";
    public static final String TABLE="table";

    public static final String ENTITYNAME="";


    //</editor-fold>
}
