package cn.net.vidyo.framework.builder.config;

import cn.net.vidyo.framework.builder.domain.DateType;
import cn.net.vidyo.framework.builder.template.ITemplate;
import cn.net.vidyo.framework.builder.template.Template;
import org.springframework.util.Assert;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class Project extends ProjectItem {

    private DateType dateType = DateType.TIME_PACK;
    public static final String ROOT_MODULE_NAME = "root";
    Map<String,String> aliasMap = new HashMap<>();

    public Project() {

    }

    public String getAlias(String key){
        if(aliasMap.containsKey(key)){
            return aliasMap.get(key);
        }
        return "";
    }
    public Project addAlias(String... nameAliass){
        for(int index=0;index<nameAliass.length;index++){
            String key=nameAliass[index];
            String alias=nameAliass[index+1];
            aliasMap.put(key,alias);
            index++;
        }
        return this;
    }
    public Module addRootModule() {
        Module module = new Module();
        module.setName(ROOT_MODULE_NAME);
        module.setComment(ROOT_MODULE_NAME);
        module.setOutpath("");
        module.setNamespace("");
        module.setOverrideModel(this.overrideModel);
        addModule(module);
        return module;
    }

    public Module getRootModule() {
        return getModule(ROOT_MODULE_NAME);
    }

    public Project addDefaultTemplate() {
        Module rootModule = getRootModule();
        if(rootModule==null){
            rootModule=addRootModule();
        }


        addModuleTemplate(
                rootModule.getName(),
                getDefaultEntityTemplate(),
                getDefaultDaoTemplate(),
                getDefaultMapperXmlTemplate(),
                getDefaultAutoServiceTemplate(),
                getDefaultAutoServiceImplTemplate(),
                getDefaultServiceTemplate(),
                getDefaultServiceImplTemplate(),
                getDefaultConditionTemplate(),
                getDefaultConverterTemplate(),
                getDefaultAutoControllerTemplate(),
                getDefaultUiApiTemplate()
        );
        return this;
    }
    public Project addRootModuleTemplate(ITemplate... templates){
        return addModuleTemplate(ROOT_MODULE_NAME,templates);
    }
    public Project addModuleTemplate(String moduleName, ITemplate... templates){
        Module module = getModule(moduleName);
        Assert.notNull(module,"没有这个模块"+moduleName);
        module.addTemplate(templates);
        return this;
    }
    public Template getDefaultEntityTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/entity.java.ftl");
        template.setName("entity");
        template.setPath("/service/data/entity");
        template.setNamespace(".data.entity");
        template.setPrefix("");
        template.setPostfix(".java");
        return template;
    }
    public Template getDefaultDaoTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/dao.java.ftl");
        template.setName("dao");
        template.setPath("/service/data/auto/dao");
        template.setNamespace(".data.auto.dao");
        template.setPrefix("");
        template.setPostfix("Dao.java");
        return template;
    }
    public Template getDefaultAutoServiceTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/autoservice.java.ftl");
        template.setName("autoservice");
        template.setPath("/service/data/auto/service");
        template.setNamespace(".data.auto.service");
        template.setPrefix("");
        template.setPostfix("AutoService.java");
        return template;
    }
    public Template getDefaultAutoServiceImplTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/autoserviceImpl.java.ftl");
        template.setName("autoserviceImpl");
        template.setPath("/service/data/auto/service/impl");
        template.setNamespace(".data.auto.service.impl");
        template.setPrefix("");
        template.setPostfix("AutoServiceImpl.java");
        return template;
    }
    public Template getDefaultAutoConditionTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/autocondition.java.ftl");
        template.setName("autocondition");
        template.setPath("/service/data/auto/condition");
        template.setNamespace(".data.auto.condition");
        template.setPrefix("");
        template.setPostfix("AutoCondition.java");
        return template;
    }

    public Template getDefaultServiceTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/service.java.ftl");
        template.setName("service");
        template.setPath("/service/data/service");
        template.setNamespace(".data.service");
        template.setPrefix("");
        template.setPostfix("Service.java");
        return template;
    }
    public Template getDefaultServiceImplTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/serviceImpl.java.ftl");
        template.setName("serviceImpl");
        template.setPath("/service/data/service/impl");
        template.setNamespace(".data.service.impl");
        template.setPrefix("");
        template.setPostfix("ServiceImpl.java");
        return template;
    }
    public Template getDefaultOneServiceTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/oneservice.java.ftl");
        template.setName("oneservice");
        template.setPath("/service/data/service");
        template.setNamespace(".data.service");
        template.setPrefix("");
        template.setPostfix("Service.java");
        return template;
    }
    public Template getDefaultMapperXmlTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/mapper.xml.ftl");
        template.setName("mapper");
        template.setPath("/service/resources/mapper");
        template.setPrefix("");
        template.setPostfix("Mapper.xml");
        return template;
    }
    public Template getDefaultConditionTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/condition.java.ftl");
        template.setName("condition");
        template.setPath("/service/data/condition");
        template.setNamespace(".data.condition");
        template.setPrefix("");
        template.setPostfix("Condition.java");
        return template;
    }
    public Template getDefaultConverterTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/converter.java.ftl");
        template.setName("converter");
        template.setPath("/service/data/converter");
        template.setNamespace(".data.converter");
        template.setPrefix("");
        template.setPostfix("Converter.java");
        return template;
    }
    public Template getDefaultAutoControllerTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/autocontroller.java.ftl");
        template.setName("autocontroller");
        template.setPath("/api/web/auto");
        template.setNamespace(".web.auto");
        template.setPrefix("");
        template.setPostfix("AutoController.java");
        return template;
    }
    public Template getDefaultUiApiTemplate() {
        Template template = new Template();
        template.setTemplatePath("template/web.ui.api.ts.ftl");
        template.setName("uiapi");
        template.setPath("/ui/src/api/auto");
        template.setNamespace(".web.ui.auto");
        template.setPrefix("");
        template.setPostfix(".ts");
        return template;
    }

    public Project addModule(Module... modules) {
        for (Module module : modules) {
            if (module.getNamespace().length() > 0) {
                module.setFullNamespace(this.namespace + "." + module.getNamespace());
            } else {
                module.setFullNamespace(this.namespace);
            }
            if (module.getOutpath().length() > 0) {
                module.setFullOutpath(this.getOutpath() + File.separator + module.getOutpath());
            } else {
                module.setFullOutpath(this.getOutpath());
            }
        }
        addItem(modules);
        return this;
    }

    public Module getModule(String name) {
        ProjectItem item = getItem(name);
        return (Module) item;
    }

    public Module getModuleByTableName(String tableName) {
        for (ProjectItem item : items) {
            Module module = (Module) item;
            if (module.containsByTableName(name)) {
                return module;
            }
        }
        return null;
    }

    public Project addTableName(String moduleName, String... tableNames) {
        Module module = getModule(moduleName);
        if (module == null) {
            module = new Module();
            module.setName(moduleName);
            module.setComment(moduleName);
            module.setOutpath(moduleName);
            module.setNamespace(moduleName);
            module.setOverrideModel(this.overrideModel);
            addItem(module);
        }
        module.addTableName(tableNames);
        return this;
    }

    public DateType getDateType() {
        return dateType;
    }

    public void setDateType(DateType dateType) {
        this.dateType = dateType;
    }
}
