package cn.net.vidyo.framework.generate.util;

import cn.net.vidyo.framework.generate.gen.entity.TemplateConfig;
import org.springframework.util.StringUtils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * 模板元信息工具类
 */
public final class TemplateMetaUtils {

    private TemplateMetaUtils() {
    }

    /**
     * 解析模板内容中的元信息
     * @param content s
     * @return s
     */
    public static Map<String, String> parseMetaContent(String content) {
        content = StringUtils.trimLeadingWhitespace(content);
        if (content != null && content.startsWith("##")) {
            int rowIdx = content.indexOf('\n');
            String metaInfo = content.substring(2, rowIdx);
            return parseMetaRow(metaInfo);
        }
        return Collections.emptyMap();
    }

    /**
     * 解析元数据信息
     * @param row s
     * @return s
     */
    public static Map<String, String> parseMetaRow(String row) {
        Map<String, String> data = new HashMap<>();
        String[] paris = row.split("\\s*,\\s*");
        for (String item : paris) {
            String[] kv = item.split("=");
            data.put(kv[0].trim(), kv.length == 1 ? null : kv[1].trim());
        }
        return data;
    }

    /**
     * 生成元数据的模板内容
     * @param template  ss
     * @return s
     */
    public static String generateMetaContent(TemplateConfig template) {
        String content = StringUtils.trimLeadingWhitespace(template.getContent());
        String metaRow = generateMetaRow(template);
        if (content.startsWith("##")) {
            int rowIdx = content.indexOf('\n');
            if(rowIdx == -1) {
                content = metaRow;
            } else {
                content = metaRow + content.substring(rowIdx);
            }
        } else {
            content = metaRow + "\n" + content;
        }
        return content;
    }

    /**
     * 解析元数据信息
     * @param template s
     * @return s
     */
    public static String generateMetaRow(TemplateConfig template) {
        String format = "## filename=%s, folder=%s";
        String filename = template.getFileName() != null ? template.getFileName() : "";
        String folder = template.getFolder() != null ? template.getFolder() : "";
        return String.format(format, filename, folder);
    }
}
