package cn.net.vidyo.framework.builder.meta;

import cn.net.vidyo.framework.builder.domain.DbColumnType;
import cn.net.vidyo.framework.common.util.ValueUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableSchema {
    String schemaName="";
    String name ="";
    String entityName ="";
    String comment ="";
    boolean identityIncrement=false;
    Map<String,ColumnSchema> columnNameMap=new HashMap<>();
    List<ColumnSchema> columns=new ArrayList<>();
    List<String> excludeColumns=new ArrayList<>();
    ColumnSchema idColumn =null;
    boolean includeStatus=false;
    boolean includeName=false;

    List<ForeignKeySchema> parentForeignKeys =new ArrayList<>();
    List<ForeignKeySchema> childForeignKeys =new ArrayList<>();

    public TableSchema() {
        excludeColumns.add("id");
        excludeColumns.add("hidden");
        excludeColumns.add("createtime");
        excludeColumns.add("updatetime");
    }

    public List<ColumnSchema> getIncludeColumns(){
        List<ColumnSchema> list = new ArrayList<>();
        for (ColumnSchema column : columns) {
            if(!excludeColumns.contains(column.getName().toLowerCase())){
                list.add(column);
            }
        }
        return list;
    }

    public void addParentForeignKey(ForeignKeySchema foreignKeySchema){
        parentForeignKeys.add(foreignKeySchema);
    }
    public void addChildForeignKey(ForeignKeySchema foreignKeySchema){
        childForeignKeys.add(foreignKeySchema);
    }
    public void addColumn(ColumnSchema columnSchema){
        if(columnNameMap.containsKey(columnSchema.getName())){
            return;
        }
        columnNameMap.put(columnSchema.getName(),columnSchema);
        columns.add(columnSchema);
        if(columnSchema.getName()=="id"){
            idColumn =columnSchema;
        }
    }
    public String firstCapitalLetterName(){
        return ValueUtil.firstCapitalLetterName(name);
    }

    public String getBaseClassString(){
        DbColumnType columnType = (DbColumnType) (getIdColumn().getColumnType());
       if(columnType==DbColumnType.STRING){
           return "StringModel";
       }
        if(columnType==DbColumnType.BIG_INTEGER || columnType==DbColumnType.LONG || columnType==DbColumnType.BASE_LONG){
            return "AutoLongModel";
        }
        if(columnType==DbColumnType.INTEGER  || columnType==DbColumnType.BASE_INT){
            return "AutoIntModel";
        }
        if(columnType==null){
            System.out.println("columnType is null");
        }else{
            System.out.println("columnType is " + columnType);
        }

        return "";
    }
    public String getKeyClassString(){
        DbColumnType columnType = (DbColumnType) (getIdColumn().getColumnType());
        if(columnType==DbColumnType.STRING){
            return "String";
        }
        if(columnType==DbColumnType.BIG_INTEGER || columnType==DbColumnType.LONG || columnType==DbColumnType.BASE_LONG){
            return "Long";
        }
        if(columnType==DbColumnType.INTEGER  || columnType==DbColumnType.BASE_INT){
            return "Integer";
        }
        if(columnType==null){
            System.out.println("columnType is null");
        }else{
            System.out.println("columnType is " + columnType);
        }

        return "";
    }

    public List<ForeignKeySchema> getParentForeignKeys() {
        return parentForeignKeys;
    }

    public void setParentForeignKeys(List<ForeignKeySchema> parentForeignKeys) {
        this.parentForeignKeys = parentForeignKeys;
    }

    public List<ForeignKeySchema> getChildForeignKeys() {
        return childForeignKeys;
    }

    public void setChildForeignKeys(List<ForeignKeySchema> childForeignKeys) {
        this.childForeignKeys = childForeignKeys;
    }

    public boolean isIdentityIncrement() {
        return identityIncrement;
    }

    public void setIdentityIncrement(boolean identityIncrement) {
        this.identityIncrement = identityIncrement;
    }

    public boolean isIncludeName() {
        return includeName;
    }

    public void setIncludeName(boolean includeName) {
        this.includeName = includeName;
    }

    public boolean isIncludeStatus() {
        return includeStatus;
    }

    public void setIncludeStatus(boolean includeStatus) {
        this.includeStatus = includeStatus;
    }

    public String getSchemaName() {
        return schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = ValueUtil.firstLowercaseLetterName(name);;
        this.entityName= firstCapitalLetterName();
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<ColumnSchema> getColumns() {
        return columns;
    }

    public void setColumns(List<ColumnSchema> columns) {
        this.columns = columns;
    }

    public List<String> getExcludeColumns() {
        return excludeColumns;
    }

    public void setExcludeColumns(List<String> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    public ColumnSchema getIdColumn() {
        return idColumn;
    }

    public void setIdColumn(ColumnSchema idColumn) {
        this.idColumn = idColumn;
    }

    public String getEntityName() {
        return entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }
}
