package cn.net.vidyo.framework.builder.erstudio.util;


import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class ErStudioCommentConvert {
    private static final String type_INTEGER = "INTEGER";

    private static final String type_VARCHAR = "VARCHAR";

    private static final String type_TIMESTAMP = "TIMESTAMP";

    private static final String type_TIMESTAMP_2_DATETIME = "DATETIME";

    private static final String type_CHAR = " CHAR";

    private static final String content_1 = "COMMENT ON COLUMN ";

    private static final String content_2 = " IS";

    private static final String mysql_content_1 = "alter table ";

    private static final String mysql_content_2 = " modify column ";

    private static final String mysql_content_3 = "   comment ";

    public static void main(String[] args) {
        System.out.println("#################################################################");
        System.out.println("此工具用于解决ER/Studio设置注释defintion依然无法生成mysql的列注解的问题\n" +
                "整体步骤：\n" +
                "1.使用ER/Studio生成mysql的sql，并且在数据库中建表\n" +
                "2.使用ER/Studio生成db2的sql，用文本编辑器转换为UTF-8编码，否则会乱码\n" +
                "3.通过java jar ErStudioCommentConvert.jar 启动此工具\n" +
                "4.按提示输入db2sql文件路径，回车将会再同目录下生成mysql添加注释的文件\n" +
                "另外注意\n" +
                "1.目前只支持INTEGER，VARCHAR，TIMESTAMP，CHAR的注释生成，其他讲忽略\n" +
                "2.ER/Studio中注释内容不要换行，否则请手工调整生成的文件填补单引号和缺少内容");
        System.out.println("#################################################################");
        System.out.print("请输入DB2 SQL文件路径");
        Scanner scan = new Scanner(System.in);
        String db2patch = scan.nextLine();
        System.out.println("输入数据：" + db2patch);

        File file = new File(db2patch);
        buildMysqlcomment(db2patch,String.valueOf(file.getParent()) + File.separator);
    }

    public static void buildMysqlcomment(String db2patch,String outPath){
        String[] db2sql = ErStudioReadFile.readToString(db2patch).split("\n");
        StringBuffer sb = new StringBuffer();
        String mysqlcomment = "";
        Map<String, String> map = new HashMap<>();
        byte b;
        int i;
//        String[] arrayOfString1;
        for (i=0;i<db2sql.length;i++) {
//            if(b<0){
//                System.out.println("");
//            }
            String line = db2sql[i];
            if (line.indexOf("INTEGER") >= 0) {
                String k = line.substring(0, line.indexOf("INTEGER")).trim();
                String v = "INTEGER";
                map.put(k, v);
            }
            if (line.indexOf("VARCHAR") >= 0) {
                String k = line.substring(0, line.indexOf("VARCHAR")).trim();
                String v = line.substring(line.indexOf("VARCHAR"), line.indexOf(")") + 1).trim();
                map.put(k, v);
            }
            if (line.indexOf("TIMESTAMP") >= 0) {
                String k = line.substring(0, line.indexOf("TIMESTAMP")).trim();
                String v = "DATETIME";
                map.put(k, v);
            }
            if (line.indexOf(" CHAR") >= 0) {
                String k = line.substring(0, line.indexOf(" CHAR")).trim();
                String v = line.substring(line.indexOf(" CHAR"), line.indexOf(")") + 1).trim();
                map.put(k, v);
            }
//            b++;
        }
        for (i=0;i<db2sql.length;i++) {
            String line = db2sql[i];
            if (line.indexOf("COMMENT ON COLUMN ") >= 0)
                mysqlcomment = buildMysqlcomment(sb, line, map);
//            b++;
        }
        File file = new File(db2patch);
        ErStudioWriteFile.createFile(outPath,
                String.valueOf(file.getName().replace(".", "_")) + "_mysqlcomment_" + System.currentTimeMillis(), mysqlcomment);
    }

    private static String buildMysqlcomment(StringBuffer sb, String line, Map<String, String> map) {
        String tableName = line.substring(line.indexOf("COMMENT ON COLUMN ") + "COMMENT ON COLUMN ".length(), line.indexOf("."));
        String col = String.valueOf(line.substring(line.indexOf(".") + 1, line.indexOf(" IS"))) + " ";
        String v = map.get(col.trim());
        if (v != null && !"".equals(v)) {
            String comment = line.substring(line.indexOf(" IS") + " IS".length(), line.length());
            return sb.append("alter table ").append(tableName).append(" modify column ").append(col).append(v).append("   comment ").append(comment).append("\n")
                    .append(";").toString();
        }
        return sb.toString();
    }
}
