package cn.net.vidyo.framework.builder.erstudio;

import cn.net.vidyo.framework.builder.domain.DbColumnType;
import cn.net.vidyo.framework.builder.meta.ColumnSchema;
import cn.net.vidyo.framework.builder.meta.DatabaseSchema;
import cn.net.vidyo.framework.builder.meta.ForeignKeySchema;
import cn.net.vidyo.framework.builder.meta.TableSchema;
import cn.net.vidyo.framework.common.util.ValueUtil;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.*;
import java.util.*;

public class ParseErStudio {
    private static final int STEP_NULL = 0;
    private static final int STEP_NAME = 1;
    private static final int STEP_COLUMN = 2;
    private static final int STEP_DATA = 3;

    private static final int FUN_NULL = 0;
    private static final int FUN_BEGIN = 2;
    private static final int FUN_END = 3;
    StringBuilder content=new StringBuilder();
    boolean contentBegin=false;
    public Map<String,EntityModel> parseEntityModels(String filename) throws IOException {
        File file =new File(filename);
        InputStreamReader isr = new InputStreamReader(new FileInputStream(file), "GBK");
        BufferedReader br= new BufferedReader(isr);
        String lineSouce;
        int step=STEP_NULL;
        int fun=FUN_NULL;
        boolean first=false;
        boolean beginString=false;
        boolean fittleLargeString=false;

        EntityModel entityModel=null;
        Map<String,EntityModel> entityModelMap=new HashMap<>();
        while ((lineSouce = br.readLine()) != null) {
            String line = lineSouce.trim();
            if(line.indexOf("662,o,0,0,0")>=0){
                System.out.println("");
            }
            if(line.startsWith("LargeString")){
                fittleLargeString=true;
            }
            if(line.startsWith("StringUsage")){
                fittleLargeString=false;
            }
            if(fittleLargeString){
                continue;
            }
            boolean b1 = checkLineString(line);

            if(!beginString && b1){
                beginString=true;
                content = new StringBuilder(line);
                continue;
            }
            if(beginString){
                if(!b1){
                    content.append(line);
                    continue;
                }else{
                    beginString=false;
                    content.append(line);
                    line =content.toString();
                }
            }
            if(line.length()==0){
                first=false;
                step=STEP_NULL;
                continue;
            }
            if(line.endsWith("\"")){
                System.out.println("");
            }
            line = formatString(line);
//            if(beginString){
//                if(line.equals("StringUsage")){
//                    beginString=false;
//                    first=false;
//                }else{
//                    continue;
//                }
//            }
            if(!first){
                first=true;
                entityModel=new EntityModel();
                entityModel.setEntityName(line);
                step=STEP_NAME;
                continue;
            }
            if(first){
                switch (step){
                    case STEP_NAME:
                        String[] split = line.split(",");
                        List<EntityColumn> columns=new LinkedList<>();
                        for (String column : split) {
                            columns.add(new EntityColumn(column));
                        }
                        entityModel.setColumns(columns);
                        if(!entityModelMap.containsKey(entityModel.getEntityName())){
                            entityModelMap.put(entityModel.getEntityName(),entityModel);
                        }
                        step=STEP_COLUMN;
                        break;
                    case STEP_COLUMN:
//                        if("LargeString".endsWith(entityModel.getEntityName())){
//                            beginString=true;
//                            continue;
//                        }

                        entityModel.addData(line);
//                        System.out.println("ENTITY:"+entityModel.getEntityName());
//                        for (String column : entityModel.getColumns()) {
//                            System.out.print(column+",");
//                        }
//                        System.out.println("");
                        break;
                    case STEP_DATA:
                        break;
                }
            }


//            if(line.indexOf(".")>=0 || line.indexOf(";")>=0 || line.indexOf(".")>=0 || line.indexOf(".")>=0 || line.indexOf(".")>=0 ){
//            }else{
//
//            }
        }
//        for (EntityModel model : entityModelMap.values()) {
//            System.out.println("ENTITY:"+model.getEntityName());
//            for (String column : model.getColumns()) {
//                System.out.print(column+",");
//            }
//            System.out.println("");
//        }
        return entityModelMap;
    }

    private static final String DATATYPES_STRING = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>\n" +
            "<DataTypeMapping xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"C:\\ProgramData\\Embarcadero\\ERStudio_8.0\\DatatypeMapping\\DataTypeMapping.xsd\">\n" +
            "\n" +
            "  <DBPlatform MappingName=\"MySQL 5.x (system)\" PlatformId=\"73\">\n" +
            "    <DataType DatatypeId=\"1\" DatatypeName=\"BINARY\" Identity=\"\" Scale=\"-1\" ShortName=\"BIN\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"true\" Width=\"10\"/>\n" +
            "    <DataType DatatypeId=\"2\" DatatypeName=\"BIT\" Identity=\"\" Scale=\"0\" ShortName=\"BIT\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"true\" Width=\"1\"/>\n" +
            "    <DataType DatatypeId=\"3\" DatatypeName=\"CHAR\" Identity=\"\" Scale=\"-1\" ShortName=\"CH\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"true\" Width=\"10\"/>\n" +
            "    <DataType DatatypeId=\"4\" DatatypeName=\"NATIONAL CHAR\" Identity=\"\" Scale=\"-1\" ShortName=\"CHN\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"true\" Width=\"10\"/>\n" +
            "    <DataType DatatypeId=\"5\" DatatypeName=\"DATE\" Identity=\"\" Scale=\"-1\" ShortName=\"D\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"true\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"6\" DatatypeName=\"DECIMAL\" Identity=\"\" Scale=\"0\" ShortName=\"DC\" ShowScale=\"true\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"false\" Width=\"10\"/>\n" +
            "    <DataType DatatypeId=\"7\" DatatypeName=\"DECIMAL\" Identity=\"\" Scale=\"0\" ShortName=\"DCN\" ShowScale=\"true\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"10\"/>\n" +
            "    <DataType DatatypeId=\"8\" DatatypeName=\"DATETIME\" Identity=\"\" Scale=\"-1\" ShortName=\"DT\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"true\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"9\" DatatypeName=\"DATETIME\" Identity=\"\" Scale=\"-1\" ShortName=\"DTN\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"true\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"10\" DatatypeName=\"TEXT\" Identity=\"\" Scale=\"-1\" ShortName=\"DTX\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"11\" DatatypeName=\"FLOAT\" Identity=\"\" Scale=\"0\" ShortName=\"FLN\" ShowScale=\"true\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"8\"/>\n" +
            "    <DataType DatatypeId=\"12\" DatatypeName=\"FLOAT\" Identity=\"\" Scale=\"0\" ShortName=\"FLT\" ShowScale=\"true\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"false\" Width=\"8\"/>\n" +
            "    <DataType DatatypeId=\"13\" DatatypeName=\"INT\" Identity=\"IDENTITY\" Scale=\"-1\" ShortName=\"INT\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"14\" DatatypeName=\"INT\" Identity=\"\" Scale=\"-1\" ShortName=\"ITN\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"15\" DatatypeName=\"LONGBLOB\" Identity=\"\" Scale=\"-1\" ShortName=\"LBN\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"16\" DatatypeName=\"TEXT\" Identity=\"\" Scale=\"-1\" ShortName=\"LVA\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"17\" DatatypeName=\"VARCHAR\" Identity=\"\" Scale=\"-1\" ShortName=\"MLS\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"true\" Width=\"18\"/>\n" +
            "    <DataType DatatypeId=\"18\" DatatypeName=\"DECIMAL\" Identity=\"\" Scale=\"2\" ShortName=\"MN\" ShowScale=\"true\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"19\"/>\n" +
            "    <DataType DatatypeId=\"19\" DatatypeName=\"DECIMAL\" Identity=\"\" Scale=\"2\" ShortName=\"MNN\" ShowScale=\"true\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"19\"/>\n" +
            "    <DataType DatatypeId=\"20\" DatatypeName=\"DECIMAL\" Identity=\"\" Scale=\"2\" ShortName=\"NMN\" ShowScale=\"true\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"10\"/>\n" +
            "    <DataType DatatypeId=\"21\" DatatypeName=\"DECIMAL\" Identity=\"\" Scale=\"2\" ShortName=\"NUM\" ShowScale=\"true\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"10\"/>\n" +
            "    <DataType DatatypeId=\"22\" DatatypeName=\"BLOB\" Identity=\"\" Scale=\"-1\" ShortName=\"PIC\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"23\" DatatypeName=\"VARCHAR\" Identity=\"\" Scale=\"-1\" ShortName=\"ROW\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"true\" Width=\"18\"/>\n" +
            "    <DataType DatatypeId=\"24\" DatatypeName=\"DATETIME\" Identity=\"\" Scale=\"-1\" ShortName=\"SDT\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"true\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"25\" DatatypeName=\"INT\" Identity=\"\" Scale=\"-1\" ShortName=\"SER\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"26\" DatatypeName=\"FLOAT\" Identity=\"\" Scale=\"0\" ShortName=\"SFL\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"7\"/>\n" +
            "    <DataType DatatypeId=\"27\" DatatypeName=\"SMALLINT\" Identity=\"IDENTITY\" Scale=\"-1\" ShortName=\"SI\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"28\" DatatypeName=\"DECIMAL\" Identity=\"\" Scale=\"2\" ShortName=\"SMN\" ShowScale=\"true\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"7\"/>\n" +
            "    <DataType DatatypeId=\"29\" DatatypeName=\"TIME\" Identity=\"\" Scale=\"0\" ShortName=\"T\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"3\"/>\n" +
            "    <DataType DatatypeId=\"30\" DatatypeName=\"TINYINT\" Identity=\"IDENTITY\" Scale=\"-1\" ShortName=\"TI\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"31\" DatatypeName=\"TIMESTAMP\" Identity=\"\" Scale=\"-1\" ShortName=\"TS\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"32\" DatatypeName=\"LONGTEXT\" Identity=\"\" Scale=\"-1\" ShortName=\"TX\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"33\" DatatypeName=\"NATIONAL VARCHAR\" Identity=\"\" Scale=\"-1\" ShortName=\"VAN\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"true\" Width=\"18\"/>\n" +
            "    <DataType DatatypeId=\"34\" DatatypeName=\"VARCHAR\" Identity=\"\" Scale=\"-1\" ShortName=\"VAR\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"true\" Width=\"18\"/>\n" +
            "    <DataType DatatypeId=\"35\" DatatypeName=\"VARBINARY\" Identity=\"\" Scale=\"-1\" ShortName=\"VBN\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"true\" Width=\"18\"/>\n" +
            "    <DataType DatatypeId=\"36\" DatatypeName=\"INT\" Identity=\"\" Scale=\"-1\" ShortName=\"CNT\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"37\" DatatypeName=\"DOUBLE\" Identity=\"\" Scale=\"0\" ShortName=\"DBL\" ShowScale=\"true\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"false\" Width=\"18\"/>\n" +
            "    <DataType DatatypeId=\"38\" DatatypeName=\"BINARY\" Identity=\"\" Scale=\"-1\" ShortName=\"UID\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"16\"/>\n" +
            "    <DataType DatatypeId=\"39\" DatatypeName=\"BIGINT\" Identity=\"IDENTITY\" Scale=\"-1\" ShortName=\"LIN\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"19\"/>\n" +
            "    <DataType DatatypeId=\"40\" DatatypeName=\"BINARY\" Identity=\"\" Scale=\"-1\" ShortName=\"VNT\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"20\"/>\n" +
            "    <DataType DatatypeId=\"41\" DatatypeName=\"DATETIME\" Identity=\"\" Scale=\"0\" ShortName=\"ITV\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"42\" DatatypeName=\"LONGBLOB\" Identity=\"\" Scale=\"-1\" ShortName=\"XML\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"43\" DatatypeName=\"DATETIME\" Identity=\"\" Scale=\"-1\" ShortName=\"DTO\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n" +
            "    <DataType DatatypeId=\"44\" DatatypeName=\"CHAR\" Identity=\"\" Scale=\"-1\" ShortName=\"HID\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"10\"/>\n" +
            "  </DBPlatform>\n" +
            "\n" +
            "</DataTypeMapping>";

    Map<String,String> parseDataType(){
        Map<String,String> data = new HashMap<>();
//1.创建Reader对象
        SAXReader reader = new SAXReader();
        InputStream stream=null;
        Element rootElement=null;
        //2.加载xml
        try {
            stream = new ByteArrayInputStream(DATATYPES_STRING.getBytes("UTF-8"));
            Document document = reader.read(stream);
            rootElement = document.getRootElement();
        } catch (Exception e) {
            e.printStackTrace();
            return data;
        }

        //3.获取根节点
        Iterator iterator = rootElement.elementIterator();
        while (iterator.hasNext()){
            Element DBPlatform = (Element) iterator.next();
            Iterator iterator1 = DBPlatform.elementIterator();
            while (iterator1.hasNext()){
                Element DataType = (Element) iterator1.next();
                List<Attribute> attributes = DataType.attributes();
                String id="";
                String name="";
                for (Attribute attribute : attributes) {
                    if(attribute.getName().equals("DatatypeId")){
                        id = attribute.getValue();
                    }
                    if(attribute.getName().equals("DatatypeName")){
                        name=attribute.getValue();
                    }
                    System.out.println(attribute.getValue());
                }
                data.put(id,name);
            }
        }
        return data;
    }
    public DatabaseSchema parseSchema(String filename) throws IOException{
        Map<String,String> dataTypes =parseDataType();
        DatabaseSchema databaseSchema=new DatabaseSchema();
        Map<String, EntityModel> entityModelMap = parseEntityModels(filename);
        Map<String,String> primaryKeys = converToMap(entityModelMap.get("PrimaryKey"),"Attribute_ID","PrimaryKey_ID");
        Map<String,String> StringValues = converToMap(entityModelMap.get("SmallString"),"String_Id","Data");
        Map<String,TableSchema> tableSchemaMap=new HashMap<>();
        EntityModel entityEntityModel = entityModelMap.get("Entity");
        for (Map<String, Object> data : entityEntityModel.getDatas()) {
            TableSchema tableSchema=new TableSchema();
            tableSchema.setName(ValueUtil.mapItemToString(StringValues,ValueUtil.mapItemToString(data,"TableNameId")));
            tableSchema.setComment(ValueUtil.mapItemToString(StringValues,ValueUtil.mapItemToString(data,"EntityNameId")));
            tableSchemaMap.put(ValueUtil.mapItemToString(data,"Entity_ID"),tableSchema);
            databaseSchema.addTable(tableSchema);
        }
        Set<String> dataTypeNames = new HashSet<>();
        Map<String,ColumnSchema> attributeMap=new HashMap<>();
        EntityModel attributeEntityModel = entityModelMap.get("Attribute");
        for (Map<String, Object> data : attributeEntityModel.getDatas()) {
            ColumnSchema columnSchema=new ColumnSchema();
            String attributeName = ValueUtil.mapItemToString(StringValues, ValueUtil.mapItemToString(data, "AttributeNameId"));
            String columnName = ValueUtil.mapItemToString(StringValues, ValueUtil.mapItemToString(data, "ColumnNameId")).trim();
            String definition = ValueUtil.mapItemToString(StringValues, ValueUtil.mapItemToString(data, "DefinitionId")).trim();
            columnSchema.setName(columnName);
            if(definition.length()>0) {
                columnSchema.setComment(attributeName + "： " + definition);
            }else{
                columnSchema.setComment(attributeName);
            }
            TableSchema tableSchema = tableSchemaMap.get(ValueUtil.mapItemToString(data, "Entity_ID"));
            tableSchema.addColumn(columnSchema);
            columnSchema.setLength( ValueUtil.mapItemToInt(data, "Length"));
            String attribute_id = ValueUtil.mapItemToString(data, "Attribute_ID");
            if(primaryKeys.containsKey(attribute_id)){
                tableSchema.setIdColumn(columnSchema);
            }
//            String IdentityColumn = ValueUtil.mapItemToString(data, "IdentityColumn");
//            if(IdentityColumn.equals("Y")){
//                tableSchema.setIdColumn(columnSchema);
//            }
//            String identityIncrement = ValueUtil.mapItemToString(data, "IdentityIncrement");
//            if(identityIncrement.equals("1")){
//                tableSchema.setIdentityIncrement(true);
//            }

            String datatypeId = ValueUtil.mapItemToString(data, "DatatypeId");
//            if(datatypeId.equals("69")) datatypeId="14";
//            if(datatypeId.equals("896")) datatypeId="2";
//            if(datatypeId.equals("959")) datatypeId="12";
//            if(datatypeId.equals("205")) datatypeId="34";
            String datatypeName = StringValues.get(datatypeId);
            dataTypeNames.add(datatypeName);
            switch (datatypeName){
                case "LIN":
                    columnSchema.setColumnType(DbColumnType.LONG);
                    break;
                case "CH":
                    columnSchema.setColumnType(DbColumnType.STRING);
                    break;
                case "VAR":
                    columnSchema.setColumnType(DbColumnType.STRING);
                    break;
                case "BIT":
                    columnSchema.setColumnType(DbColumnType.BOOLEAN);
                    break;
                case "INT":
                    columnSchema.setColumnType(DbColumnType.INTEGER);
                    break;
                case "FLT":
                    columnSchema.setColumnType(DbColumnType.FLOAT);
                    break;
            }
//            System.out.println("datatypeName:"+datatypeName);
//            if(datatypeName==null){
//                System.out.println("");
//            }
            String parentAttributeId = ValueUtil.mapItemToString(data, "AttributeId");
            attributeMap.put(parentAttributeId,columnSchema);
        }
        for (String dataTypeName : dataTypeNames) {
            System.out.println("TYPE:"+dataTypeName);
        }

        Map<String,ForeignKeySchema> foreignKeySchemaMap=new HashMap<>();
        EntityModel foreignKeyEntityModel = entityModelMap.get("ForeignKey");
        for (Map<String, Object> data : foreignKeyEntityModel.getDatas()) {
            ForeignKeySchema foreignKeySchema=new ForeignKeySchema();
            TableSchema parentTable = tableSchemaMap.get(ValueUtil.mapItemToString(data, "New_Parent_Entity_ID"));
            parentTable.addParentForeignKey(foreignKeySchema);
            foreignKeySchema.setParentTable(parentTable);
            TableSchema childTable = tableSchemaMap.get(ValueUtil.mapItemToString(data, "New_Child_Entity_ID"));
            childTable.addChildForeignKey(foreignKeySchema);
            foreignKeySchema.setChildTable(childTable);
            foreignKeySchema.setRelationshipType(ValueUtil.mapItemToInt(data,"RelationshipTypeId"));
            foreignKeySchemaMap.put(ValueUtil.mapItemToString(data, "ForeignKey_ID"),foreignKeySchema);
        }
        EntityModel foreignKeyColumnEntityModel = entityModelMap.get("ForeignKeyColumn");
        for (Map<String, Object> data : foreignKeyColumnEntityModel.getDatas()) {
            ForeignKeySchema foreignKeySchema=foreignKeySchemaMap.get(ValueUtil.mapItemToString(data,"ForeignKey_ID"));
            String parentAttributeId = ValueUtil.mapItemToString(data, "ParentAttributeId");
            String childAttributeId = ValueUtil.mapItemToString(data, "ChildAttributeId");
            String originalAttributeId = ValueUtil.mapItemToString(data, "OriginalAttributeId");
            System.out.println(StringValues.get(parentAttributeId)+"--"+StringValues.get(childAttributeId)+"--"+StringValues.get(originalAttributeId)+"--");
//            ColumnSchema columnSchema = attributeMap.get(originalAttributeId);
            foreignKeySchema.setParentColumn(foreignKeySchema.getParentTable().getIdColumn());
            foreignKeySchema.setChildColumn(attributeMap.get(childAttributeId));
            System.out.println("");
        }
//
//
//        Map<String, Object> modelData = entityModelMap.get("Model").getDatas().get(0);
//        String modelId = ValueUtil.mapItemToString(modelData, "ModelId");
//        System.out.println("ModelId:"+ modelId +" "+ ValueUtil.mapItemToString(idNames,modelId));
        return databaseSchema;
    }

    public Map<String,String> converToMap(EntityModel entityModel,String idKey,String nameKey){
        Map<String,String> data = new HashMap<>();
        for (Map<String, Object> item : entityModel.getDatas()) {
            data.put(ValueUtil.mapItemToString(item,idKey),ValueUtil.mapItemToString(item,nameKey));
        }
        return data;
    }
    void outModel(Map<String,String> idNames,EntityModel entityModel){
        switch (entityModel.getEntityName()){
//            case "Attribute":
//                outIdName(idNames,entityModel,"AttributeId");
//                break;
            case "Entity":
                outIdName(idNames,entityModel,"EntityId");
                outIdName(idNames,entityModel,"EntityNameId");
                outIdName(idNames,entityModel,"TableNameId");
                break;
        }
    }
    void outIdName(Map<String,String> idNames,EntityModel entityModel,String idKey){
        System.out.println("MODEL:"+entityModel.getEntityName());
        for (Map<String, Object> data : entityModel.getDatas()) {
            String id = ValueUtil.mapItemToString(data, idKey);
            String val = ValueUtil.mapItemToString(idNames, id);
            System.out.println(id +"\t"+val);
        }
    }
    boolean checkLineString(String content){
        String[] datas = content.split("\"");
        int length = datas.length;
        if(content.endsWith("\"")){
            length++;
        }
        return length%2==0;
    }
    String formatString(String line){
        String text = line;
        StringBuilder content = new StringBuilder();
        while (true){
            int pos1 = text.indexOf("\"");
            if(pos1<0){
                content.append(text);
                break;
            }
            int pos2 = text.indexOf("\"",pos1+1);
            if(pos2<0){
                throw new IllegalArgumentException("引号不匹配");
            }
            content.append(text.substring(0,pos1));
            String dd = text.substring(pos1+1,pos2);
            dd=dd.replace(",",";");
            content.append("\""+dd+"\"");
            text = text.substring(pos2+1);


        }
        return content.toString();
    }

}
