package cn.net.vidyo.framework.builder.config;

import cn.net.vidyo.framework.builder.template.ITemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Module extends ProjectItem{
    String fullNamespace="";
    String fullOutpath="";
    boolean exclude=true;

    List<String> tableNames = new ArrayList<>();
    Map<String, ITemplate> templateMap=new HashMap<>();

    public Module addTemplate(ITemplate... templates){
        for (ITemplate template : templates) {
            templateMap.put(template.getName(),template);
        }
        return this;
    }

    public Map<String, ITemplate> getTemplateMap() {
        return templateMap;
    }

    public void setTemplateMap(Map<String, ITemplate> templateMap) {
        this.templateMap = templateMap;
    }


    public Module addTableName(String... names){
        for (String name : names) {
            this.tableNames.add(name.toLowerCase());
        }
        return this;
    }

    Map<String, Map> tableModel =new HashMap<>();
    public Module addTable(String key, Map data){
        tableModel.put(key,data);
        return this;
    }

    public boolean isExcludeTable(String tableName){
        if(exclude){
            return tableNames.contains(tableName.toLowerCase());
        }else{
            return !tableNames.contains(tableName.toLowerCase());
        }
    }

    public boolean containsByTableName(String tableName){
        return tableNames.contains(tableName);
    }

    public String getFullNamespace() {
        return fullNamespace;
    }

    public void setFullNamespace(String fullNamespace) {
        this.fullNamespace = fullNamespace;
    }

    public List<String> getTableNames() {
        return tableNames;
    }

    public void setTableNames(List<String> tableNames) {
        this.tableNames = tableNames;
    }

    public Map<String, Map> getTableModel() {
        return tableModel;
    }

    public void setTableModel(Map<String, Map> tableModel) {
        this.tableModel = tableModel;
    }

    public String getFullOutpath() {
        return fullOutpath;
    }

    public void setFullOutpath(String fullOutpath) {
        this.fullOutpath = fullOutpath;
    }

    public boolean isExclude() {
        return exclude;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }
}
