package cn.net.vidyo.framework.builder.config;

import cn.net.vidyo.framework.builder.domain.DateType;
import cn.net.vidyo.framework.builder.domain.DbType;
import cn.net.vidyo.framework.builder.template.ITemplate;
import cn.net.vidyo.framework.builder.template.Template;


public class GlobalConfig {
    String namespace="";
    /**
     * 生成文件的输出目录【 windows:D://  linux or mac:/tmp 】
     */
    private String outputDir = System.getProperty("os.name").toLowerCase().contains("windows") ? "D://" : "/tmp";

    /**
     * 是否覆盖已有文件（默认 false）（3.5.3版本会删除此方法）
     */
    @Deprecated
    private boolean fileOverride;

    /**
     * 是否打开输出目录
     */
    private boolean open = true;

    /**
     * 作者
     */
    private String author = "作者";

    /**
     * 开启 Kotlin 模式（默认 false）
     */
    private boolean kotlin;

    /**
     * 开启 swagger 模式（默认 false）
     */
    private boolean swagger;

    /**
     * 时间类型对应策略
     */
    private DateType dateType = DateType.TIME_PACK;

    public DbType getDbType(String str) {
        if (str.contains(":mysql:") || str.contains(":cobar:")) {
            return DbType.MYSQL;
        } else if (str.contains(":oracle:")) {
            return DbType.ORACLE;
        } else if (str.contains(":postgresql:")) {
            return DbType.POSTGRE_SQL;
        } else if (str.contains(":sqlserver:")) {
            return DbType.SQL_SERVER;
        } else if (str.contains(":db2:")) {
            return DbType.DB2;
        } else if (str.contains(":mariadb:")) {
            return DbType.MARIADB;
        } else if (str.contains(":sqlite:")) {
            return DbType.SQLITE;
        } else if (str.contains(":h2:")) {
            return DbType.H2;
        } else if (str.contains(":kingbase:") || str.contains(":kingbase8:")) {
            return DbType.KINGBASE_ES;
        } else if (str.contains(":dm:")) {
            return DbType.DM;
        } else if (str.contains(":zenith:")) {
            return DbType.GAUSS;
        } else if (str.contains(":oscar:")) {
            return DbType.OSCAR;
        } else if (str.contains(":firebird:")) {
            return DbType.FIREBIRD;
        } else if (str.contains(":xugu:")) {
            return DbType.XU_GU;
        } else if (str.contains(":clickhouse:")) {
            return DbType.CLICK_HOUSE;
        } else if (str.contains(":sybase:")) {
            return DbType.SYBASE;
        } else {
            return DbType.OTHER;
        }
    }

    DataSourceConfig dataSourceConfig=new DataSourceConfig();
    StrategyConfig strategyConfig=new StrategyConfig();
    TemplateConfig templateConfig =new TemplateConfig();

    public GlobalConfig setDataSource(String url,String username,String password){
        dataSourceConfig.setUrl(url);
        dataSourceConfig.setUsername(username);
        dataSourceConfig.setPassword(password);
        return this;
    }

    public GlobalConfig addTemplate(ITemplate... templates){
        this.templateConfig.addTemplate(templates);
        return this;
    }

    public GlobalConfig addDefaultTemplates(){
        Template template=new Template();
        template.setTemplatePath("template/entity.java.ftl");
        template.setName("entity");
        template.setPath("/data/entity");
        template.setNamespace(".data.entity");
        template.setPrefix("");
        template.setPostfix(".java");
        template.setNamespace(template.getPath().replaceAll("/","."));
        templateConfig.addTemplate(template);

        template=new Template();
        template.setTemplatePath("template/dao.java.ftl");
        template.setName("dao");
        template.setPath("/data/dao");
        template.setNamespace(".data.dao");
        template.setPrefix("");
        template.setPostfix("Dao.java");
        templateConfig.addTemplate(template);

        template=new Template();
        template.setTemplatePath("template/service.java.ftl");
        template.setName("service");
        template.setPath("/data/service");
        template.setNamespace(".data.service");
        template.setPrefix("");
        template.setPostfix("Service.java");
        templateConfig.addTemplate(template);

        template=new Template();
        template.setTemplatePath("template/serviceImpl.java.ftl");
        template.setName("serviceImpl");
        template.setPath("/data/service/impl");
        template.setNamespace(".data.service.impl");
        template.setPrefix("");
        template.setPostfix("ServiceImpl.java");
        templateConfig.addTemplate(template);

        template=new Template();
        template.setTemplatePath("template/mapper.xml.ftl");
        template.setName("mapper");
        template.setPath("/resources/mapper");
        template.setPrefix("");
        template.setPostfix("Mapper.xml");
        templateConfig.addTemplate(template);

        template=new Template();
        template.setTemplatePath("template/condition.java.ftl");
        template.setName("condition");
        template.setPath("/data/condition");
        template.setNamespace(".data.condition");
        template.setPrefix("");
        template.setPostfix("Condition.java");
        templateConfig.addTemplate(template);

        template=new Template();
        template.setTemplatePath("template/converter.java.ftl");
        template.setName("converter");
        template.setPath("/data/converter");
        template.setNamespace(".data.converter");
        template.setPrefix("");
        template.setPostfix("Converter.java");
        templateConfig.addTemplate(template);

        template=new Template();
        template.setTemplatePath("template/controller.java.ftl");
        template.setName("controller");
        template.setPath("/web/api");
        template.setNamespace(".web.api");
        template.setPrefix("");
        template.setPostfix("Controller.java");
        templateConfig.addTemplate(template);
        return this;
    }

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getOutputDir() {
        return outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public boolean isFileOverride() {
        return fileOverride;
    }

    public void setFileOverride(boolean fileOverride) {
        this.fileOverride = fileOverride;
    }

    public boolean isOpen() {
        return open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public boolean isKotlin() {
        return kotlin;
    }

    public void setKotlin(boolean kotlin) {
        this.kotlin = kotlin;
    }

    public boolean isSwagger() {
        return swagger;
    }

    public void setSwagger(boolean swagger) {
        this.swagger = swagger;
    }

    public DateType getDateType() {
        return dateType;
    }

    public void setDateType(DateType dateType) {
        this.dateType = dateType;
    }

    public DataSourceConfig getDataSourceConfig() {
        return dataSourceConfig;
    }

    public void setDataSourceConfig(DataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
    }

    public StrategyConfig getStrategyConfig() {
        return strategyConfig;
    }

    public void setStrategyConfig(StrategyConfig strategyConfig) {
        this.strategyConfig = strategyConfig;
    }

    public TemplateConfig getTemplateConfig() {
        return templateConfig;
    }

    public void setTemplateConfig(TemplateConfig templateConfig) {
        this.templateConfig = templateConfig;
    }
}
