package cn.net.vidyo.framework.builder.build;

import cn.net.vidyo.framework.builder.config.DataSourceConfig;
import cn.net.vidyo.framework.builder.config.GlobalConfig;
import cn.net.vidyo.framework.builder.meta.DatabaseSchema;
import cn.net.vidyo.framework.builder.meta.TableSchema;
import cn.net.vidyo.framework.builder.database.query.DefaultDatabaseQuery;

import java.util.List;

public class DataSourceMetaBuildExecuter implements DatabaseMetaBuildExecuter{
    DataSourceConfig dataSourceConfig;
    GlobalConfig globalConfig;

    public DataSourceMetaBuildExecuter setDataSource(String url, String username, String password){
        if(dataSourceConfig==null){
            dataSourceConfig=new DataSourceConfig();
        }
        dataSourceConfig.setUrl(url);
        dataSourceConfig.setUsername(username);
        dataSourceConfig.setPassword(password);
        return this;
    }
    public DataSourceMetaBuildExecuter setGlobalConfig(GlobalConfig globalConfig){
        this.globalConfig=globalConfig;
        return this;
    }

    @Override
    public DatabaseSchema build() {
        DefaultDatabaseQuery defaultDatabaseQuery=new DefaultDatabaseQuery(globalConfig);
        List<TableSchema> tableSchemas = defaultDatabaseQuery.queryTables();
        DatabaseSchema databaseSchema=new DatabaseSchema();
        databaseSchema.setTables(tableSchemas);
        return databaseSchema;
    }
}
