/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen.oracle;

import cn.net.vidyo.framework.generate.gen.ColumnDefinition;
import cn.net.vidyo.framework.generate.gen.ColumnSelector;
import cn.net.vidyo.framework.generate.gen.GeneratorConfig;
import cn.net.vidyo.framework.generate.gen.TypeFormatter;
import cn.net.vidyo.framework.generate.gen.oracle.OracleTypeFormatter;
import cn.net.vidyo.framework.generate.util.FieldUtil;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class OracleColumnSelector
extends ColumnSelector {
    private static final TypeFormatter TYPE_FORMATTER = new OracleTypeFormatter();
    private static final String COLUMN_SQL = " SELECT  atc.COLUMN_NAME FIELD, atc.DATA_TYPE TYPE, atc.DATA_SCALE SCALE, atc.DATA_LENGTH MAXLENGTH,  CASE atc.NULLABLE NULLABLE ,  atc.DATA_DEFAULT \u9ed8\u8ba4\u503c, acc.COMMENTS COMMENTS, atc.TABLE_NAME \u8868\u540d,  CASE atc.COLUMN_NAME  WHEN  ( SELECT col.column_name FROM all_constraints con \tLEFT JOIN all_cons_columns col ON con.table_name = col.table_name \tAND con.OWNER = col.OWNER AND con.CONSTRAINT_NAME = col.CONSTRAINT_NAME    WHERE con.constraint_type = 'P' \tAND col.table_name = '%s' AND con.OWNER = '%s' )  THEN 'true' ELSE 'false' END AS KEY  FROM ALL_TAB_COLUMNS atc  LEFT JOIN ALL_COL_COMMENTS acc  ON acc.TABLE_NAME = atc.TABLE_NAME AND acc.COLUMN_NAME = atc.COLUMN_NAME  AND acc.OWNER = atc.OWNER  WHERE atc.TABLE_NAME = '%s' AND atc.OWNER = '%s'  ORDER BY atc.COLUMN_ID ";

    public OracleColumnSelector(GeneratorConfig generatorConfig) {
        super(generatorConfig);
    }

    @Override
    protected String getColumnInfoSQL(String tableName) {
        String owner = this.getGeneratorConfig().getSchemaName();
        return String.format(COLUMN_SQL, tableName, owner, tableName, owner);
    }

    @Override
    protected ColumnDefinition buildColumnDefinition(Map<String, Object> rowMap) {
        String scale;
        Set<String> columnSet = rowMap.keySet();
        for (String columnInfo : columnSet) {
            rowMap.put(columnInfo.toUpperCase(), rowMap.get(columnInfo));
        }
        ColumnDefinition columnDefinition = new ColumnDefinition();
        columnDefinition.setColumnName(FieldUtil.convertString(rowMap.get("FIELD")));
        columnDefinition.setIsIdentity(false);
        boolean isPk = "true".equalsIgnoreCase(FieldUtil.convertString(rowMap.get("KEY")));
        columnDefinition.setIsPk(isPk);
        String type = FieldUtil.convertString(rowMap.get("TYPE"));
        if (StringUtils.containsIgnoreCase((String)type, (String)"number")) {
            Object scaleCol = rowMap.get("SCALE");
            if (scaleCol == null) {
                scaleCol = 0;
            }
            type = "0".equals(scale = String.valueOf(scaleCol)) ? "int" : "decimal";
        }
        columnDefinition.setType(TYPE_FORMATTER.format(type));
        columnDefinition.setComment(FieldUtil.convertString(rowMap.get("COMMENTS")));
        String maxLength = FieldUtil.convertString(rowMap.get("MAXLENGTH"));
        columnDefinition.setMaxLength(new Integer(StringUtils.isEmpty((String)maxLength) ? "0" : maxLength));
        scale = FieldUtil.convertString(rowMap.get("SCALE"));
        columnDefinition.setScale(new Integer(StringUtils.isEmpty((String)scale) ? "0" : scale));
        String isNullable = FieldUtil.convertString(rowMap.get("NULLABLE"));
        columnDefinition.setIsNullable(!"N".equalsIgnoreCase(isNullable));
        return columnDefinition;
    }
}

