/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen;

import cn.net.vidyo.framework.generate.gen.ColumnDefinition;
import cn.net.vidyo.framework.generate.gen.ColumnSelector;
import cn.net.vidyo.framework.generate.gen.CsharpColumnDefinition;
import cn.net.vidyo.framework.generate.gen.GeneratorConfig;
import cn.net.vidyo.framework.generate.gen.JavaColumnDefinition;
import cn.net.vidyo.framework.generate.gen.SqlHelper;
import cn.net.vidyo.framework.generate.gen.TableDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public abstract class TableSelector {
    private ColumnSelector columnSelector;
    private GeneratorConfig generatorConfig;
    private List<String> schTableNames;

    public TableSelector(ColumnSelector columnSelector, GeneratorConfig generatorConfig) {
        this.generatorConfig = generatorConfig;
        this.columnSelector = columnSelector;
    }

    protected abstract String getShowTablesSQL(GeneratorConfig var1);

    protected abstract TableDefinition buildTableDefinition(Map<String, Object> var1);

    public List<TableDefinition> getTableDefinitions() {
        List<Map<String, Object>> resultList = SqlHelper.runSql(this.getGeneratorConfig(), this.getShowTablesSQL(this.generatorConfig));
        ArrayList<TableDefinition> tablesList = new ArrayList<TableDefinition>(resultList.size());
        for (Map<String, Object> rowMap : resultList) {
            TableDefinition tableDefinition = this.buildTableDefinition(rowMap);
            String tableName = tableDefinition.getTableName();
            List<ColumnDefinition> columnDefinitions = this.columnSelector.getColumnDefinitions(tableName);
            tableDefinition.setColumnDefinitions(this.buildRealColumnDefinitions(columnDefinitions, JavaColumnDefinition::new));
            tableDefinition.setCsharpColumnDefinitions(this.buildRealColumnDefinitions(columnDefinitions, CsharpColumnDefinition::new));
            tablesList.add(tableDefinition);
        }
        return tablesList;
    }

    private <T> List<T> buildRealColumnDefinitions(List<ColumnDefinition> columnDefinitions, Supplier<T> supplier) {
        return columnDefinitions.stream().map(columnDefinition -> {
            Object t = supplier.get();
            BeanUtils.copyProperties((Object)columnDefinition, t);
            return t;
        }).collect(Collectors.toList());
    }

    public List<TableDefinition> getSimpleTableDefinitions() {
        List<Map<String, Object>> resultList = SqlHelper.runSql(this.getGeneratorConfig(), this.getShowTablesSQL(this.generatorConfig));
        ArrayList<TableDefinition> tablesList = new ArrayList<TableDefinition>(resultList.size());
        for (Map<String, Object> rowMap : resultList) {
            tablesList.add(this.buildTableDefinition(rowMap));
        }
        return tablesList;
    }

    public List<String> wrapTableNames() {
        List<String> schTableNames = this.getSchTableNames();
        if (CollectionUtils.isEmpty(schTableNames)) {
            return Collections.emptyList();
        }
        return schTableNames.stream().map(this::wrapValue).collect(Collectors.toList());
    }

    protected String wrapValue(String tableName) {
        return String.format("'%s'", tableName);
    }

    public GeneratorConfig getGeneratorConfig() {
        return this.generatorConfig;
    }

    public void setGeneratorConfig(GeneratorConfig generatorConfig) {
        this.generatorConfig = generatorConfig;
    }

    public ColumnSelector getColumnSelector() {
        return this.columnSelector;
    }

    public void setColumnSelector(ColumnSelector columnSelector) {
        this.columnSelector = columnSelector;
    }

    public List<String> getSchTableNames() {
        return this.schTableNames;
    }

    public void setSchTableNames(List<String> schTableNames) {
        this.schTableNames = schTableNames;
    }
}

