/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.erstudio;

import cn.net.vidyo.framework.builder.domain.DbColumnType;
import cn.net.vidyo.framework.builder.erstudio.EntityColumn;
import cn.net.vidyo.framework.builder.erstudio.EntityModel;
import cn.net.vidyo.framework.builder.meta.ColumnSchema;
import cn.net.vidyo.framework.builder.meta.DatabaseSchema;
import cn.net.vidyo.framework.builder.meta.ForeignKeySchema;
import cn.net.vidyo.framework.builder.meta.TableSchema;
import cn.net.vidyo.framework.common.util.ValueUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ParseErStudio {
    private static final int STEP_NULL = 0;
    private static final int STEP_NAME = 1;
    private static final int STEP_COLUMN = 2;
    private static final int STEP_DATA = 3;
    private static final int FUN_NULL = 0;
    private static final int FUN_BEGIN = 2;
    private static final int FUN_END = 3;
    StringBuilder content = new StringBuilder();
    boolean contentBegin = false;
    private static final String DATATYPES_STRING = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>\n<DataTypeMapping xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"C:\\ProgramData\\Embarcadero\\ERStudio_8.0\\DatatypeMapping\\DataTypeMapping.xsd\">\n\n  <DBPlatform MappingName=\"MySQL 5.x (system)\" PlatformId=\"73\">\n    <DataType DatatypeId=\"1\" DatatypeName=\"BINARY\" Identity=\"\" Scale=\"-1\" ShortName=\"BIN\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"true\" Width=\"10\"/>\n    <DataType DatatypeId=\"2\" DatatypeName=\"BIT\" Identity=\"\" Scale=\"0\" ShortName=\"BIT\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"true\" Width=\"1\"/>\n    <DataType DatatypeId=\"3\" DatatypeName=\"CHAR\" Identity=\"\" Scale=\"-1\" ShortName=\"CH\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"true\" Width=\"10\"/>\n    <DataType DatatypeId=\"4\" DatatypeName=\"NATIONAL CHAR\" Identity=\"\" Scale=\"-1\" ShortName=\"CHN\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"true\" Width=\"10\"/>\n    <DataType DatatypeId=\"5\" DatatypeName=\"DATE\" Identity=\"\" Scale=\"-1\" ShortName=\"D\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"true\" Width=\"-2\"/>\n    <DataType DatatypeId=\"6\" DatatypeName=\"DECIMAL\" Identity=\"\" Scale=\"0\" ShortName=\"DC\" ShowScale=\"true\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"false\" Width=\"10\"/>\n    <DataType DatatypeId=\"7\" DatatypeName=\"DECIMAL\" Identity=\"\" Scale=\"0\" ShortName=\"DCN\" ShowScale=\"true\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"10\"/>\n    <DataType DatatypeId=\"8\" DatatypeName=\"DATETIME\" Identity=\"\" Scale=\"-1\" ShortName=\"DT\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"true\" Width=\"-2\"/>\n    <DataType DatatypeId=\"9\" DatatypeName=\"DATETIME\" Identity=\"\" Scale=\"-1\" ShortName=\"DTN\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"true\" Width=\"-2\"/>\n    <DataType DatatypeId=\"10\" DatatypeName=\"TEXT\" Identity=\"\" Scale=\"-1\" ShortName=\"DTX\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"11\" DatatypeName=\"FLOAT\" Identity=\"\" Scale=\"0\" ShortName=\"FLN\" ShowScale=\"true\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"8\"/>\n    <DataType DatatypeId=\"12\" DatatypeName=\"FLOAT\" Identity=\"\" Scale=\"0\" ShortName=\"FLT\" ShowScale=\"true\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"false\" Width=\"8\"/>\n    <DataType DatatypeId=\"13\" DatatypeName=\"INT\" Identity=\"IDENTITY\" Scale=\"-1\" ShortName=\"INT\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"14\" DatatypeName=\"INT\" Identity=\"\" Scale=\"-1\" ShortName=\"ITN\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"15\" DatatypeName=\"LONGBLOB\" Identity=\"\" Scale=\"-1\" ShortName=\"LBN\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"16\" DatatypeName=\"TEXT\" Identity=\"\" Scale=\"-1\" ShortName=\"LVA\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"17\" DatatypeName=\"VARCHAR\" Identity=\"\" Scale=\"-1\" ShortName=\"MLS\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"true\" Width=\"18\"/>\n    <DataType DatatypeId=\"18\" DatatypeName=\"DECIMAL\" Identity=\"\" Scale=\"2\" ShortName=\"MN\" ShowScale=\"true\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"19\"/>\n    <DataType DatatypeId=\"19\" DatatypeName=\"DECIMAL\" Identity=\"\" Scale=\"2\" ShortName=\"MNN\" ShowScale=\"true\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"19\"/>\n    <DataType DatatypeId=\"20\" DatatypeName=\"DECIMAL\" Identity=\"\" Scale=\"2\" ShortName=\"NMN\" ShowScale=\"true\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"10\"/>\n    <DataType DatatypeId=\"21\" DatatypeName=\"DECIMAL\" Identity=\"\" Scale=\"2\" ShortName=\"NUM\" ShowScale=\"true\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"10\"/>\n    <DataType DatatypeId=\"22\" DatatypeName=\"BLOB\" Identity=\"\" Scale=\"-1\" ShortName=\"PIC\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"23\" DatatypeName=\"VARCHAR\" Identity=\"\" Scale=\"-1\" ShortName=\"ROW\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"true\" Width=\"18\"/>\n    <DataType DatatypeId=\"24\" DatatypeName=\"DATETIME\" Identity=\"\" Scale=\"-1\" ShortName=\"SDT\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"true\" Width=\"-2\"/>\n    <DataType DatatypeId=\"25\" DatatypeName=\"INT\" Identity=\"\" Scale=\"-1\" ShortName=\"SER\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"26\" DatatypeName=\"FLOAT\" Identity=\"\" Scale=\"0\" ShortName=\"SFL\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"7\"/>\n    <DataType DatatypeId=\"27\" DatatypeName=\"SMALLINT\" Identity=\"IDENTITY\" Scale=\"-1\" ShortName=\"SI\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"28\" DatatypeName=\"DECIMAL\" Identity=\"\" Scale=\"2\" ShortName=\"SMN\" ShowScale=\"true\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"7\"/>\n    <DataType DatatypeId=\"29\" DatatypeName=\"TIME\" Identity=\"\" Scale=\"0\" ShortName=\"T\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"3\"/>\n    <DataType DatatypeId=\"30\" DatatypeName=\"TINYINT\" Identity=\"IDENTITY\" Scale=\"-1\" ShortName=\"TI\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"31\" DatatypeName=\"TIMESTAMP\" Identity=\"\" Scale=\"-1\" ShortName=\"TS\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"32\" DatatypeName=\"LONGTEXT\" Identity=\"\" Scale=\"-1\" ShortName=\"TX\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"33\" DatatypeName=\"NATIONAL VARCHAR\" Identity=\"\" Scale=\"-1\" ShortName=\"VAN\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"true\" Width=\"18\"/>\n    <DataType DatatypeId=\"34\" DatatypeName=\"VARCHAR\" Identity=\"\" Scale=\"-1\" ShortName=\"VAR\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"true\" Width=\"18\"/>\n    <DataType DatatypeId=\"35\" DatatypeName=\"VARBINARY\" Identity=\"\" Scale=\"-1\" ShortName=\"VBN\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"true\" Width=\"18\"/>\n    <DataType DatatypeId=\"36\" DatatypeName=\"INT\" Identity=\"\" Scale=\"-1\" ShortName=\"CNT\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"37\" DatatypeName=\"DOUBLE\" Identity=\"\" Scale=\"0\" ShortName=\"DBL\" ShowScale=\"true\" ShowType=\"true\" ShowWidth=\"true\" Undefined=\"false\" Width=\"18\"/>\n    <DataType DatatypeId=\"38\" DatatypeName=\"BINARY\" Identity=\"\" Scale=\"-1\" ShortName=\"UID\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"16\"/>\n    <DataType DatatypeId=\"39\" DatatypeName=\"BIGINT\" Identity=\"IDENTITY\" Scale=\"-1\" ShortName=\"LIN\" ShowScale=\"false\" ShowType=\"true\" ShowWidth=\"false\" Undefined=\"false\" Width=\"19\"/>\n    <DataType DatatypeId=\"40\" DatatypeName=\"BINARY\" Identity=\"\" Scale=\"-1\" ShortName=\"VNT\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"20\"/>\n    <DataType DatatypeId=\"41\" DatatypeName=\"DATETIME\" Identity=\"\" Scale=\"0\" ShortName=\"ITV\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"42\" DatatypeName=\"LONGBLOB\" Identity=\"\" Scale=\"-1\" ShortName=\"XML\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"43\" DatatypeName=\"DATETIME\" Identity=\"\" Scale=\"-1\" ShortName=\"DTO\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"false\" Undefined=\"false\" Width=\"-2\"/>\n    <DataType DatatypeId=\"44\" DatatypeName=\"CHAR\" Identity=\"\" Scale=\"-1\" ShortName=\"HID\" ShowScale=\"false\" ShowType=\"false\" ShowWidth=\"true\" Undefined=\"false\" Width=\"10\"/>\n  </DBPlatform>\n\n</DataTypeMapping>";

    public Map<String, EntityModel> parseEntityModels(String filename) throws IOException {
        String lineSouce;
        File file = new File(filename);
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), "GBK");
        BufferedReader br = new BufferedReader(isr);
        int step = 0;
        boolean fun = false;
        boolean first = false;
        boolean beginString = false;
        boolean fittleLargeString = false;
        EntityModel entityModel = null;
        HashMap<String, EntityModel> entityModelMap = new HashMap<String, EntityModel>();
        while ((lineSouce = br.readLine()) != null) {
            String line = lineSouce.trim();
            if (line.indexOf("662,o,0,0,0") >= 0) {
                System.out.println("");
            }
            if (line.startsWith("LargeString")) {
                fittleLargeString = true;
            }
            if (line.startsWith("StringUsage")) {
                fittleLargeString = false;
            }
            if (fittleLargeString) continue;
            boolean b1 = this.checkLineString(line);
            if (!beginString && b1) {
                beginString = true;
                this.content = new StringBuilder(line);
                continue;
            }
            if (beginString) {
                if (!b1) {
                    this.content.append(line);
                    continue;
                }
                beginString = false;
                this.content.append(line);
                line = this.content.toString();
            }
            if (line.length() == 0) {
                first = false;
                step = 0;
                continue;
            }
            if (line.endsWith("\"")) {
                System.out.println("");
            }
            line = this.formatString(line);
            if (!first) {
                first = true;
                entityModel = new EntityModel();
                entityModel.setEntityName(line);
                step = 1;
                continue;
            }
            if (!first) continue;
            switch (step) {
                case 1: {
                    String[] split = line.split(",");
                    LinkedList<EntityColumn> columns = new LinkedList<EntityColumn>();
                    for (String column : split) {
                        columns.add(new EntityColumn(column));
                    }
                    entityModel.setColumns(columns);
                    if (!entityModelMap.containsKey(entityModel.getEntityName())) {
                        entityModelMap.put(entityModel.getEntityName(), entityModel);
                    }
                    step = 2;
                    break;
                }
                case 2: {
                    entityModel.addData(line);
                    break;
                }
            }
        }
        return entityModelMap;
    }

    Map<String, String> parseDataType() {
        HashMap<String, String> data = new HashMap<String, String>();
        SAXReader reader = new SAXReader();
        ByteArrayInputStream stream = null;
        Element rootElement = null;
        try {
            stream = new ByteArrayInputStream(DATATYPES_STRING.getBytes("UTF-8"));
            Document document = reader.read((InputStream)stream);
            rootElement = document.getRootElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            return data;
        }
        Iterator iterator = rootElement.elementIterator();
        while (iterator.hasNext()) {
            Element DBPlatform = (Element)iterator.next();
            Iterator iterator1 = DBPlatform.elementIterator();
            while (iterator1.hasNext()) {
                Element DataType = (Element)iterator1.next();
                List attributes = DataType.attributes();
                String id = "";
                String name = "";
                for (Attribute attribute : attributes) {
                    if (attribute.getName().equals("DatatypeId")) {
                        id = attribute.getValue();
                    }
                    if (attribute.getName().equals("DatatypeName")) {
                        name = attribute.getValue();
                    }
                    System.out.println(attribute.getValue());
                }
                data.put(id, name);
            }
        }
        return data;
    }

    public DatabaseSchema parseSchema(String filename) throws IOException {
        Map<String, String> dataTypes = this.parseDataType();
        DatabaseSchema databaseSchema = new DatabaseSchema();
        Map<String, EntityModel> entityModelMap = this.parseEntityModels(filename);
        Map<String, String> primaryKeys = this.converToMap(entityModelMap.get("PrimaryKey"), "Attribute_ID", "PrimaryKey_ID");
        Map<String, String> StringValues = this.converToMap(entityModelMap.get("SmallString"), "String_Id", "Data");
        HashMap<String, TableSchema> tableSchemaMap = new HashMap<String, TableSchema>();
        EntityModel entityEntityModel = entityModelMap.get("Entity");
        for (Map<String, Object> data : entityEntityModel.getDatas()) {
            TableSchema tableSchema = new TableSchema();
            tableSchema.setName(ValueUtil.mapItemToString(StringValues, (String)ValueUtil.mapItemToString(data, (String)"TableNameId")));
            tableSchema.setComment(ValueUtil.mapItemToString(StringValues, (String)ValueUtil.mapItemToString(data, (String)"EntityNameId")));
            tableSchemaMap.put(ValueUtil.mapItemToString(data, (String)"Entity_ID"), tableSchema);
            databaseSchema.addTable(tableSchema);
        }
        HashSet<String> dataTypeNames = new HashSet<String>();
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        EntityModel attributeEntityModel = entityModelMap.get("Attribute");
        for (Map<String, Object> data : attributeEntityModel.getDatas()) {
            ColumnSchema columnSchema = new ColumnSchema();
            String string = ValueUtil.mapItemToString(StringValues, (String)ValueUtil.mapItemToString(data, (String)"AttributeNameId"));
            String columnName = ValueUtil.mapItemToString(StringValues, (String)ValueUtil.mapItemToString(data, (String)"ColumnNameId")).trim();
            String definition = ValueUtil.mapItemToString(StringValues, (String)ValueUtil.mapItemToString(data, (String)"DefinitionId")).trim();
            columnSchema.setName(columnName);
            if (definition.length() > 0) {
                columnSchema.setComment(string + "\uff1a " + definition);
            } else {
                columnSchema.setComment(string);
            }
            TableSchema tableSchema = (TableSchema)tableSchemaMap.get(ValueUtil.mapItemToString(data, (String)"Entity_ID"));
            tableSchema.addColumn(columnSchema);
            columnSchema.setLength(ValueUtil.mapItemToInt(data, (String)"Length"));
            String attribute_id = ValueUtil.mapItemToString(data, (String)"Attribute_ID");
            if (primaryKeys.containsKey(attribute_id)) {
                tableSchema.setIdColumn(columnSchema);
            }
            String datatypeId = ValueUtil.mapItemToString(data, (String)"DatatypeId");
            String datatypeName = StringValues.get(datatypeId);
            dataTypeNames.add(datatypeName);
            switch (datatypeName) {
                case "LIN": {
                    columnSchema.setColumnType(DbColumnType.LONG);
                    break;
                }
                case "CH": {
                    columnSchema.setColumnType(DbColumnType.STRING);
                    break;
                }
                case "VAR": {
                    columnSchema.setColumnType(DbColumnType.STRING);
                    break;
                }
                case "BIT": {
                    columnSchema.setColumnType(DbColumnType.BOOLEAN);
                    break;
                }
                case "INT": {
                    columnSchema.setColumnType(DbColumnType.INTEGER);
                    break;
                }
                case "FLT": {
                    columnSchema.setColumnType(DbColumnType.FLOAT);
                }
            }
            String parentAttributeId = ValueUtil.mapItemToString(data, (String)"AttributeId");
            attributeMap.put(parentAttributeId, columnSchema);
        }
        for (String dataTypeName : dataTypeNames) {
            System.out.println("TYPE:" + dataTypeName);
        }
        HashMap<String, ForeignKeySchema> foreignKeySchemaMap = new HashMap<String, ForeignKeySchema>();
        EntityModel foreignKeyEntityModel = entityModelMap.get("ForeignKey");
        for (Map map : foreignKeyEntityModel.getDatas()) {
            ForeignKeySchema foreignKeySchema = new ForeignKeySchema();
            TableSchema parentTable = (TableSchema)tableSchemaMap.get(ValueUtil.mapItemToString((Map)map, (String)"New_Parent_Entity_ID"));
            parentTable.addParentForeignKey(foreignKeySchema);
            foreignKeySchema.setParentTable(parentTable);
            TableSchema childTable = (TableSchema)tableSchemaMap.get(ValueUtil.mapItemToString((Map)map, (String)"New_Child_Entity_ID"));
            childTable.addChildForeignKey(foreignKeySchema);
            foreignKeySchema.setChildTable(childTable);
            foreignKeySchema.setRelationshipType(ValueUtil.mapItemToInt((Map)map, (String)"RelationshipTypeId"));
            foreignKeySchemaMap.put(ValueUtil.mapItemToString((Map)map, (String)"ForeignKey_ID"), foreignKeySchema);
        }
        EntityModel foreignKeyColumnEntityModel = entityModelMap.get("ForeignKeyColumn");
        for (Map<String, Object> data : foreignKeyColumnEntityModel.getDatas()) {
            ForeignKeySchema foreignKeySchema = (ForeignKeySchema)foreignKeySchemaMap.get(ValueUtil.mapItemToString(data, (String)"ForeignKey_ID"));
            String parentAttributeId = ValueUtil.mapItemToString(data, (String)"ParentAttributeId");
            String childAttributeId = ValueUtil.mapItemToString(data, (String)"ChildAttributeId");
            String originalAttributeId = ValueUtil.mapItemToString(data, (String)"OriginalAttributeId");
            System.out.println(StringValues.get(parentAttributeId) + "--" + StringValues.get(childAttributeId) + "--" + StringValues.get(originalAttributeId) + "--");
            foreignKeySchema.setParentColumn(foreignKeySchema.getParentTable().getIdColumn());
            foreignKeySchema.setChildColumn((ColumnSchema)attributeMap.get(childAttributeId));
            System.out.println("");
        }
        return databaseSchema;
    }

    public Map<String, String> converToMap(EntityModel entityModel, String idKey, String nameKey) {
        HashMap<String, String> data = new HashMap<String, String>();
        for (Map<String, Object> item : entityModel.getDatas()) {
            data.put(ValueUtil.mapItemToString(item, (String)idKey), ValueUtil.mapItemToString(item, (String)nameKey));
        }
        return data;
    }

    void outModel(Map<String, String> idNames, EntityModel entityModel) {
        switch (entityModel.getEntityName()) {
            case "Entity": {
                this.outIdName(idNames, entityModel, "EntityId");
                this.outIdName(idNames, entityModel, "EntityNameId");
                this.outIdName(idNames, entityModel, "TableNameId");
            }
        }
    }

    void outIdName(Map<String, String> idNames, EntityModel entityModel, String idKey) {
        System.out.println("MODEL:" + entityModel.getEntityName());
        for (Map<String, Object> data : entityModel.getDatas()) {
            String id = ValueUtil.mapItemToString(data, (String)idKey);
            String val = ValueUtil.mapItemToString(idNames, (String)id);
            System.out.println(id + "\t" + val);
        }
    }

    boolean checkLineString(String content) {
        String[] datas = content.split("\"");
        int length = datas.length;
        if (content.endsWith("\"")) {
            ++length;
        }
        return length % 2 == 0;
    }

    String formatString(String line) {
        String text = line;
        StringBuilder content = new StringBuilder();
        while (true) {
            int pos1;
            if ((pos1 = text.indexOf("\"")) < 0) break;
            int pos2 = text.indexOf("\"", pos1 + 1);
            if (pos2 < 0) {
                throw new IllegalArgumentException("\u5f15\u53f7\u4e0d\u5339\u914d");
            }
            content.append(text.substring(0, pos1));
            String dd = text.substring(pos1 + 1, pos2);
            dd = dd.replace(",", ";");
            content.append("\"" + dd + "\"");
            text = text.substring(pos2 + 1);
        }
        content.append(text);
        return content.toString();
    }
}

