package cn.net.vidyo.framework.dd.meta;

import cn.net.vidyo.framework.dd.config.Module;
import cn.net.vidyo.framework.dd.config.Project;

import java.util.LinkedList;
import java.util.List;

public class DatabaseSchema {
    List<TableSchema> tables=new LinkedList<>();

    boolean exclude=false;
    List<String> excludeTableNames =new LinkedList<>();

    public DatabaseSchema addTable(TableSchema tableSchema){
        tables.add(tableSchema);
        return this;
    }
    public DatabaseSchema addExcludeTableNames(boolean exclude, String... names) {
        this.exclude = exclude;
        for (String s : names) {
            excludeTableNames.add(s);
        }
        return this;
    }

    public List<TableSchema> getTables() {
        return tables;
    }

    public void setTables(List<TableSchema> tables) {
        this.tables = tables;
    }

    public boolean isExclude() {
        return exclude;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public List<String> getExcludeTableNames() {
        return excludeTableNames;
    }

    public void setExcludeTableNames(List<String> excludeTableNames) {
        this.excludeTableNames = excludeTableNames;
    }
}
