package cn.net.vidyo.framework.builder.engine;

import cn.net.vidyo.framework.builder.TemplateModel;
import cn.net.vidyo.framework.builder.config.GlobalConfig;
import cn.net.vidyo.framework.builder.config.Module;
import cn.net.vidyo.framework.builder.config.Project;
import cn.net.vidyo.framework.builder.meta.TableSchema;
import cn.net.vidyo.framework.builder.template.ITemplate;

import java.io.File;
import java.net.URL;
import java.util.Map;

public abstract class AbstractTemplateEngine implements ITemplateEngine {
    public boolean write(GlobalConfig globalConfig, ITemplate template, Object model) {
        String outputDir = globalConfig.getOutputDir();
        Object tableName = "";
        String outFilePath = "";
        String fileName="";
        if ((model instanceof TemplateModel)) {
            TemplateModel tmodel = (TemplateModel) model;
            if(template.getFileName().equalsIgnoreCase("entityName")){
                fileName=template.getPrefix() + tmodel.getModel().get("entityName") + template.getPostfix();
            }else{
                fileName=template.getPrefix()+ template.getPostfix();
            }
            if(template.isPathAddEntity()){
                outFilePath = outputDir + template.getPath() + File.separator + tmodel.getModel().get("entityName") + File.separator + fileName;
            }else{
                outFilePath = outputDir + template.getPath() + File.separator + fileName;
            }
        } else {
            Map map = (Map) model;
            Project project = (Project) map.get("project");
            Module module = (Module) map.get("module");
            TableSchema tableSchema = (TableSchema) map.get("table");
            if(template.getFileName().equalsIgnoreCase("entityName")){
                fileName=template.getPrefix() + tableSchema.getEntityName() + template.getPostfix();
            }else{
                fileName=template.getPrefix()+ template.getPostfix();
            }
            if(template.isPathAddEntity()){
                outFilePath = module.getFullOutpath() + template.getPath() + File.separator + tableSchema.getEntityName() + File.separator + fileName;
            }else{
                outFilePath = module.getFullOutpath() + template.getPath() + File.separator + fileName;
            }

        }
        File file = new File(outFilePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
//        URL resource = this.getClass().getResource(template.getTemplatePath());
//        String path=  resource.getFile();
//        if(path.startsWith("/")){
//            path =path.substring(1);
//        }
        System.out.println("build file -->> " + outFilePath);
        return write(template.getTemplatePath(), outFilePath, model);
    }
}
