/*
 * Copyright (c) 2011-2021, baomidou (jobob@qq.com).
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package cn.net.vidyo.framework.builder.database.domain;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * 表数据查询接口\
 */
public interface IDbQuery {
    /**
     * 表信息查询 SQL
     * @return ss
     */
    String tablesSql();

    /**
     * 表字段信息查询 SQL
     * @return ss
     */
    String tableFieldsSql();

    /**
     * 表名称
     * @return ss
     */
    String tableName();

    /**
     * 表注释
     * @deprecated 3.5.3
     * @return ss
     */
//    @Deprecated
    String tableComment();

    /**
     * 字段名称
     * @return ss
     */
    String fieldName();

    /**
     * 字段类型
     * @return ss
     */
    String fieldType();

    /**
     * 字段注释
     * @deprecated 3.5.3
     * @return ss
     */
    @Deprecated
    String fieldComment();

    /**
     * 主键字段
     * @deprecated 3.5.3
     * @return  ss
     */
//    @Deprecated
    String fieldKey();

    /**
     * 判断主键是否为identity
     *
     * @param results ResultSet
     * @return 主键是否为identity
     * @throws SQLException ignore
     * @deprecated 3.5.3
     */
//    @Deprecated
    boolean isKeyIdentity(ResultSet results) throws SQLException;

    /**
     * 自定义字段名称
     * @return ss
     */
    String[] fieldCustom();
}
