/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.erstudio.util;

import cn.net.vidyo.framework.builder.erstudio.util.ErStudioReadFile;
import cn.net.vidyo.framework.builder.erstudio.util.ErStudioWriteFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class ErStudioCommentConvert {
    private static final String type_INTEGER = "INTEGER";
    private static final String type_VARCHAR = "VARCHAR";
    private static final String type_TIMESTAMP = "TIMESTAMP";
    private static final String type_TIMESTAMP_2_DATETIME = "DATETIME";
    private static final String type_CHAR = " CHAR";
    private static final String content_1 = "COMMENT ON COLUMN ";
    private static final String content_2 = " IS";
    private static final String mysql_content_1 = "alter table ";
    private static final String mysql_content_2 = " modify column ";
    private static final String mysql_content_3 = "   comment ";

    public static void main(String[] args) {
        System.out.println("#################################################################");
        System.out.println("\u6b64\u5de5\u5177\u7528\u4e8e\u89e3\u51b3ER/Studio\u8bbe\u7f6e\u6ce8\u91cadefintion\u4f9d\u7136\u65e0\u6cd5\u751f\u6210mysql\u7684\u5217\u6ce8\u89e3\u7684\u95ee\u9898\n\u6574\u4f53\u6b65\u9aa4\uff1a\n1.\u4f7f\u7528ER/Studio\u751f\u6210mysql\u7684sql\uff0c\u5e76\u4e14\u5728\u6570\u636e\u5e93\u4e2d\u5efa\u8868\n2.\u4f7f\u7528ER/Studio\u751f\u6210db2\u7684sql\uff0c\u7528\u6587\u672c\u7f16\u8f91\u5668\u8f6c\u6362\u4e3aUTF-8\u7f16\u7801\uff0c\u5426\u5219\u4f1a\u4e71\u7801\n3.\u901a\u8fc7java jar ErStudioCommentConvert.jar \u542f\u52a8\u6b64\u5de5\u5177\n4.\u6309\u63d0\u793a\u8f93\u5165db2sql\u6587\u4ef6\u8def\u5f84\uff0c\u56de\u8f66\u5c06\u4f1a\u518d\u540c\u76ee\u5f55\u4e0b\u751f\u6210mysql\u6dfb\u52a0\u6ce8\u91ca\u7684\u6587\u4ef6\n\u53e6\u5916\u6ce8\u610f\n1.\u76ee\u524d\u53ea\u652f\u6301INTEGER\uff0cVARCHAR\uff0cTIMESTAMP\uff0cCHAR\u7684\u6ce8\u91ca\u751f\u6210\uff0c\u5176\u4ed6\u8bb2\u5ffd\u7565\n2.ER/Studio\u4e2d\u6ce8\u91ca\u5185\u5bb9\u4e0d\u8981\u6362\u884c\uff0c\u5426\u5219\u8bf7\u624b\u5de5\u8c03\u6574\u751f\u6210\u7684\u6587\u4ef6\u586b\u8865\u5355\u5f15\u53f7\u548c\u7f3a\u5c11\u5185\u5bb9");
        System.out.println("#################################################################");
        System.out.print("\u8bf7\u8f93\u5165DB2 SQL\u6587\u4ef6\u8def\u5f84");
        Scanner scan = new Scanner(System.in);
        String db2patch = scan.nextLine();
        System.out.println("\u8f93\u5165\u6570\u636e\uff1a" + db2patch);
        File file = new File(db2patch);
        ErStudioCommentConvert.buildMysqlcomment(db2patch, String.valueOf(file.getParent()) + File.separator);
    }

    public static void buildMysqlcomment(String db2patch, String outPath) {
        String line;
        int i;
        String[] db2sql = ErStudioReadFile.readToString(db2patch).split("\n");
        StringBuffer sb = new StringBuffer();
        String mysqlcomment = "";
        HashMap<String, String> map = new HashMap<String, String>();
        for (i = 0; i < db2sql.length; ++i) {
            String v;
            String k;
            line = db2sql[i];
            if (line.indexOf(type_INTEGER) >= 0) {
                k = line.substring(0, line.indexOf(type_INTEGER)).trim();
                v = type_INTEGER;
                map.put(k, v);
            }
            if (line.indexOf(type_VARCHAR) >= 0) {
                k = line.substring(0, line.indexOf(type_VARCHAR)).trim();
                v = line.substring(line.indexOf(type_VARCHAR), line.indexOf(")") + 1).trim();
                map.put(k, v);
            }
            if (line.indexOf(type_TIMESTAMP) >= 0) {
                k = line.substring(0, line.indexOf(type_TIMESTAMP)).trim();
                v = type_TIMESTAMP_2_DATETIME;
                map.put(k, v);
            }
            if (line.indexOf(type_CHAR) < 0) continue;
            k = line.substring(0, line.indexOf(type_CHAR)).trim();
            v = line.substring(line.indexOf(type_CHAR), line.indexOf(")") + 1).trim();
            map.put(k, v);
        }
        for (i = 0; i < db2sql.length; ++i) {
            line = db2sql[i];
            if (line.indexOf(content_1) < 0) continue;
            mysqlcomment = ErStudioCommentConvert.buildMysqlcomment(sb, line, map);
        }
        File file = new File(db2patch);
        ErStudioWriteFile.createFile(outPath, String.valueOf(file.getName().replace(".", "_")) + "_mysqlcomment_" + System.currentTimeMillis(), mysqlcomment);
    }

    private static String buildMysqlcomment(StringBuffer sb, String line, Map<String, String> map) {
        String tableName = line.substring(line.indexOf(content_1) + content_1.length(), line.indexOf("."));
        String col = String.valueOf(line.substring(line.indexOf(".") + 1, line.indexOf(content_2))) + " ";
        String v = map.get(col.trim());
        if (v != null && !"".equals(v)) {
            String comment = line.substring(line.indexOf(content_2) + content_2.length(), line.length());
            return sb.append(mysql_content_1).append(tableName).append(mysql_content_2).append(col).append(v).append(mysql_content_3).append(comment).append("\n").append(";").toString();
        }
        return sb.toString();
    }
}

