/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.config;

import cn.net.vidyo.framework.builder.config.DataSourceConfig;
import cn.net.vidyo.framework.builder.config.StrategyConfig;
import cn.net.vidyo.framework.builder.config.TemplateConfig;
import cn.net.vidyo.framework.builder.domain.DateType;
import cn.net.vidyo.framework.builder.domain.DbType;
import cn.net.vidyo.framework.builder.template.ITemplate;
import cn.net.vidyo.framework.builder.template.Template;

public class GlobalConfig {
    String namespace = "";
    private String outputDir = System.getProperty("os.name").toLowerCase().contains("windows") ? "D://" : "/tmp";
    @Deprecated
    private boolean fileOverride;
    private boolean open = true;
    private String author = "\u4f5c\u8005";
    private boolean kotlin;
    private boolean swagger;
    private DateType dateType = DateType.TIME_PACK;
    DataSourceConfig dataSourceConfig = new DataSourceConfig();
    StrategyConfig strategyConfig = new StrategyConfig();
    TemplateConfig templateConfig = new TemplateConfig();

    public DbType getDbType(String str) {
        if (str.contains(":mysql:") || str.contains(":cobar:")) {
            return DbType.MYSQL;
        }
        if (str.contains(":oracle:")) {
            return DbType.ORACLE;
        }
        if (str.contains(":postgresql:")) {
            return DbType.POSTGRE_SQL;
        }
        if (str.contains(":sqlserver:")) {
            return DbType.SQL_SERVER;
        }
        if (str.contains(":db2:")) {
            return DbType.DB2;
        }
        if (str.contains(":mariadb:")) {
            return DbType.MARIADB;
        }
        if (str.contains(":sqlite:")) {
            return DbType.SQLITE;
        }
        if (str.contains(":h2:")) {
            return DbType.H2;
        }
        if (str.contains(":kingbase:") || str.contains(":kingbase8:")) {
            return DbType.KINGBASE_ES;
        }
        if (str.contains(":dm:")) {
            return DbType.DM;
        }
        if (str.contains(":zenith:")) {
            return DbType.GAUSS;
        }
        if (str.contains(":oscar:")) {
            return DbType.OSCAR;
        }
        if (str.contains(":firebird:")) {
            return DbType.FIREBIRD;
        }
        if (str.contains(":xugu:")) {
            return DbType.XU_GU;
        }
        if (str.contains(":clickhouse:")) {
            return DbType.CLICK_HOUSE;
        }
        if (str.contains(":sybase:")) {
            return DbType.SYBASE;
        }
        return DbType.OTHER;
    }

    public GlobalConfig setDataSource(String url, String username, String password) {
        this.dataSourceConfig.setUrl(url);
        this.dataSourceConfig.setUsername(username);
        this.dataSourceConfig.setPassword(password);
        return this;
    }

    public GlobalConfig addTemplate(ITemplate ... templates) {
        this.templateConfig.addTemplate(templates);
        return this;
    }

    public GlobalConfig addDefaultTemplates() {
        Template template = new Template();
        template.setTemplatePath("template/entity.java.ftl");
        template.setName("entity");
        template.setPath("/data/entity");
        template.setNamespace(".data.entity");
        template.setPrefix("");
        template.setPostfix(".java");
        template.setNamespace(template.getPath().replaceAll("/", "."));
        this.templateConfig.addTemplate(template);
        template = new Template();
        template.setTemplatePath("template/dao.java.ftl");
        template.setName("dao");
        template.setPath("/data/dao");
        template.setNamespace(".data.dao");
        template.setPrefix("");
        template.setPostfix("Dao.java");
        this.templateConfig.addTemplate(template);
        template = new Template();
        template.setTemplatePath("template/service.java.ftl");
        template.setName("service");
        template.setPath("/data/service");
        template.setNamespace(".data.service");
        template.setPrefix("");
        template.setPostfix("Service.java");
        this.templateConfig.addTemplate(template);
        template = new Template();
        template.setTemplatePath("template/serviceImpl.java.ftl");
        template.setName("serviceImpl");
        template.setPath("/data/service/impl");
        template.setNamespace(".data.service.impl");
        template.setPrefix("");
        template.setPostfix("ServiceImpl.java");
        this.templateConfig.addTemplate(template);
        template = new Template();
        template.setTemplatePath("template/mapper.xml.ftl");
        template.setName("mapper");
        template.setPath("/resources/mapper");
        template.setPrefix("");
        template.setPostfix("Mapper.xml");
        this.templateConfig.addTemplate(template);
        template = new Template();
        template.setTemplatePath("template/condition.java.ftl");
        template.setName("condition");
        template.setPath("/data/condition");
        template.setNamespace(".data.condition");
        template.setPrefix("");
        template.setPostfix("Condition.java");
        this.templateConfig.addTemplate(template);
        template = new Template();
        template.setTemplatePath("template/converter.java.ftl");
        template.setName("converter");
        template.setPath("/data/converter");
        template.setNamespace(".data.converter");
        template.setPrefix("");
        template.setPostfix("Converter.java");
        this.templateConfig.addTemplate(template);
        template = new Template();
        template.setTemplatePath("template/controller.java.ftl");
        template.setName("controller");
        template.setPath("/web/api");
        template.setNamespace(".web.api");
        template.setPrefix("");
        template.setPostfix("Controller.java");
        this.templateConfig.addTemplate(template);
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public boolean isFileOverride() {
        return this.fileOverride;
    }

    public void setFileOverride(boolean fileOverride) {
        this.fileOverride = fileOverride;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public boolean isKotlin() {
        return this.kotlin;
    }

    public void setKotlin(boolean kotlin) {
        this.kotlin = kotlin;
    }

    public boolean isSwagger() {
        return this.swagger;
    }

    public void setSwagger(boolean swagger) {
        this.swagger = swagger;
    }

    public DateType getDateType() {
        return this.dateType;
    }

    public void setDateType(DateType dateType) {
        this.dateType = dateType;
    }

    public DataSourceConfig getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    public void setDataSourceConfig(DataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
    }

    public StrategyConfig getStrategyConfig() {
        return this.strategyConfig;
    }

    public void setStrategyConfig(StrategyConfig strategyConfig) {
        this.strategyConfig = strategyConfig;
    }

    public TemplateConfig getTemplateConfig() {
        return this.templateConfig;
    }

    public void setTemplateConfig(TemplateConfig templateConfig) {
        this.templateConfig = templateConfig;
    }
}

