/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.database.querys;

import cn.net.vidyo.framework.builder.database.domain.IDbQuery;
import cn.net.vidyo.framework.builder.database.querys.ClickHouseQuery;
import cn.net.vidyo.framework.builder.database.querys.DB2Query;
import cn.net.vidyo.framework.builder.database.querys.DMQuery;
import cn.net.vidyo.framework.builder.database.querys.FirebirdQuery;
import cn.net.vidyo.framework.builder.database.querys.GaussQuery;
import cn.net.vidyo.framework.builder.database.querys.GbaseQuery;
import cn.net.vidyo.framework.builder.database.querys.H2Query;
import cn.net.vidyo.framework.builder.database.querys.KingbaseESQuery;
import cn.net.vidyo.framework.builder.database.querys.MariadbQuery;
import cn.net.vidyo.framework.builder.database.querys.MySqlQuery;
import cn.net.vidyo.framework.builder.database.querys.OracleQuery;
import cn.net.vidyo.framework.builder.database.querys.OscarQuery;
import cn.net.vidyo.framework.builder.database.querys.PostgreSqlQuery;
import cn.net.vidyo.framework.builder.database.querys.SqlServerQuery;
import cn.net.vidyo.framework.builder.database.querys.SqliteQuery;
import cn.net.vidyo.framework.builder.database.querys.SybaseQuery;
import cn.net.vidyo.framework.builder.database.querys.XuguQuery;
import cn.net.vidyo.framework.builder.domain.DbType;
import java.util.EnumMap;
import java.util.Map;

public class DbQueryRegistry {
    private final Map<DbType, IDbQuery> db_query_enum_map = new EnumMap<DbType, IDbQuery>(DbType.class);

    public DbQueryRegistry() {
        this.db_query_enum_map.put(DbType.ORACLE, new OracleQuery());
        this.db_query_enum_map.put(DbType.SQL_SERVER, new SqlServerQuery());
        this.db_query_enum_map.put(DbType.POSTGRE_SQL, new PostgreSqlQuery());
        this.db_query_enum_map.put(DbType.DB2, new DB2Query());
        this.db_query_enum_map.put(DbType.MARIADB, new MariadbQuery());
        this.db_query_enum_map.put(DbType.H2, new H2Query());
        this.db_query_enum_map.put(DbType.SQLITE, new SqliteQuery());
        this.db_query_enum_map.put(DbType.DM, new DMQuery());
        this.db_query_enum_map.put(DbType.KINGBASE_ES, new KingbaseESQuery());
        this.db_query_enum_map.put(DbType.MYSQL, new MySqlQuery());
        this.db_query_enum_map.put(DbType.GAUSS, new GaussQuery());
        this.db_query_enum_map.put(DbType.OSCAR, new OscarQuery());
        this.db_query_enum_map.put(DbType.FIREBIRD, new FirebirdQuery());
        this.db_query_enum_map.put(DbType.XU_GU, new XuguQuery());
        this.db_query_enum_map.put(DbType.CLICK_HOUSE, new ClickHouseQuery());
        this.db_query_enum_map.put(DbType.GBASE, new GbaseQuery());
        this.db_query_enum_map.put(DbType.SYBASE, new SybaseQuery());
    }

    public IDbQuery getDbQuery(DbType dbType) {
        return this.db_query_enum_map.get((Object)dbType);
    }
}

