package cn.net.vidyo.framework.generate.gen;


import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DBConnect {

    public static Connection getConnection(GeneratorConfig config) throws ClassNotFoundException, SQLException {
        String driverClass = config.getDriverClass();
        Class.forName(driverClass);
        String jdbcUrl = config.getJdbcUrl();
        System.out.println("CONNECT URL：" +jdbcUrl + " ["+config.getUsername()+":"+config.getPassword()+":"+config.getDriverClass()+"]");
        return DriverManager.getConnection(jdbcUrl,
                config.getUsername(), config.getPassword());
    }

    /**
     * 测试连接,返回错误信息,无返回内容说明连接成功
     *
     * @param generatorConfig 数据源配置
     * @return 返回错误信息, 无返回内容说明连接成功
     */
    public static String testConnection(GeneratorConfig generatorConfig) {
        Connection con = null;
        String ret = null;
        try {
            con = DBConnect.getConnection(generatorConfig);
            // 不为空说明连接成功
            if (con == null) {
                ret = generatorConfig.getDbName() + "连接失败";
            }
        } catch (ClassNotFoundException e) {
            ret = generatorConfig.getDbName() + "连接失败" + "，"
                    + "找不到驱动" + generatorConfig.getDriverClass();
        } catch (SQLException e) {
            ret = generatorConfig.getDbName() + "连接失败" + "，"
                    + e.getMessage();
        } finally {
            if (con != null) {
                try {
                    con.close(); // 关闭连接,该连接无实际用处
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }

        return ret;
    }
}
