package cn.net.vidyo.framework.builder.config;

import cn.net.vidyo.framework.builder.template.ITemplate;

import java.util.HashMap;
import java.util.Map;

public class TemplateConfig {

    Map<String, ITemplate> templateMap=new HashMap<>();

    public TemplateConfig addTemplate(ITemplate... templates){
        for (ITemplate template : templates) {
            templateMap.put(template.getName(),template);
        }
        return this;
    }

    public Map<String, ITemplate> getTemplateMap() {
        return templateMap;
    }

    public void setTemplateMap(Map<String, ITemplate> templateMap) {
        this.templateMap = templateMap;
    }
}
