/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen;

public enum DbType {
    MYSQL(1, "MySQL", "com.mysql.cj.jdbc.Driver", "jdbc:mysql://%s:%s/%s?useUnicode=true&characterEncoding=UTF-8&serverTimezone=Asia/Shanghai"),
    ORACLE(2, "Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@%s:%s%s"),
    SQL_SERVER(3, "SQL Server", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://%s:%s;DatabaseName=%s"),
    POSTGRE_SQL(4, "PostgreSQL", "org.postgresql.Driver", "jdbc:postgresql://%s:%s/%s");

    private final int type;
    private final String displayName;
    private final String driverClass;
    private final String jdbcUrl;

    private DbType(int type, String displayName, String driverClass, String jdbcUrl) {
        this.type = type;
        this.displayName = displayName;
        this.driverClass = driverClass;
        this.jdbcUrl = jdbcUrl;
    }

    public static DbType of(int type) {
        for (DbType value : DbType.values()) {
            if (value.type != type) continue;
            return value;
        }
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public int getType() {
        return this.type;
    }

    public String getDriverClass() {
        return this.driverClass;
    }
}

