/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.query;

import cn.net.vidyo.framework.builder.config.GlobalConfig;
import cn.net.vidyo.framework.builder.config.StrategyConfig;
import cn.net.vidyo.framework.builder.domain.IColumnType;
import cn.net.vidyo.framework.builder.meta.ColumnSchema;
import cn.net.vidyo.framework.builder.meta.TableSchema;
import cn.net.vidyo.framework.builder.query.AbstractDatabaseQuery;
import cn.net.vidyo.framework.builder.query.ConnectManager;
import cn.net.vidyo.framework.builder.query.DatabaseMetaDataWrapper;
import cn.net.vidyo.framework.builder.querys.DbQueryDecorator;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDatabaseQuery
extends AbstractDatabaseQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDatabaseQuery.class);
    private final StrategyConfig strategyConfig;
    private final GlobalConfig globalConfig;
    private final DbQueryDecorator dbQuery;
    private final DatabaseMetaDataWrapper databaseMetaDataWrapper;
    ConnectManager connectManager;
    private static final Pattern REGX = Pattern.compile("[~!/@#$%^&*()+\\\\\\[\\]|{};:'\",<.>?]+");

    public DefaultDatabaseQuery(GlobalConfig globalConfig) {
        super(globalConfig.getDataSourceConfig());
        this.strategyConfig = globalConfig.getStrategyConfig();
        this.dbQuery = new DbQueryDecorator(this.dataSourceConfig, this.strategyConfig);
        this.globalConfig = globalConfig;
        this.connectManager = new ConnectManager(this.dataSourceConfig);
        this.databaseMetaDataWrapper = new DatabaseMetaDataWrapper(this.connectManager.getConnection());
    }

    @Override
    public List<TableSchema> queryTables() {
        boolean isInclude = this.strategyConfig.getInclude().size() > 0;
        boolean isExclude = this.strategyConfig.getExclude().size() > 0;
        ArrayList<TableSchema> tableList = new ArrayList<TableSchema>();
        ArrayList includeTableList = new ArrayList();
        ArrayList excludeTableList = new ArrayList();
        try {
            Object notExistTables;
            this.connectManager.execute(this.dbQuery.tablesSql(), result -> {
                String tableName = result.getStringResult(this.dbQuery.tableName());
                if (StringUtils.isNotBlank((CharSequence)tableName)) {
                    DatabaseMetaDataWrapper.Table table = this.databaseMetaDataWrapper.getTableInfo(tableName);
                    TableSchema tableInfo = new TableSchema();
                    tableInfo.setName(tableName);
                    if (!this.strategyConfig.isSkipView() || !table.isView()) {
                        tableInfo.setComment(table.getRemarks());
                        if (isInclude && this.strategyConfig.matchIncludeTable(tableName)) {
                            includeTableList.add(tableInfo);
                        } else if (isExclude && this.strategyConfig.matchExcludeTable(tableName)) {
                            excludeTableList.add(tableInfo);
                        }
                        tableList.add(tableInfo);
                    }
                }
            });
            if (isExclude || isInclude) {
                notExistTables = new HashSet<String>(isExclude ? this.strategyConfig.getExclude() : this.strategyConfig.getInclude()).stream().filter(s -> !DefaultDatabaseQuery.matcherRegTable(s)).collect(Collectors.toMap(String::toLowerCase, s -> s, (o, n) -> n));
                for (TableSchema tabInfo : tableList) {
                    if (notExistTables.isEmpty()) break;
                    notExistTables.remove(tabInfo.getName().toLowerCase());
                }
                if (notExistTables.size() > 0) {
                    LOGGER.warn("\u8868[{}]\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01\uff01\uff01", (Object)String.join((CharSequence)",", notExistTables.values()));
                }
                if (isExclude) {
                    tableList.removeAll(excludeTableList);
                } else {
                    tableList.clear();
                    tableList.addAll(includeTableList);
                }
            }
            tableList.forEach(this::convertTableFields);
            notExistTables = tableList;
            return notExistTables;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.connectManager.closeConnection();
        }
    }

    public static boolean matcherRegTable(String tableName) {
        return REGX.matcher(tableName).find();
    }

    private void convertTableFields(TableSchema tableInfo) {
        String tableName = tableInfo.getName();
        try {
            HashMap<String, DatabaseMetaDataWrapper.ColumnsInfo> columnsMetaInfoMap = new HashMap<String, DatabaseMetaDataWrapper.ColumnsInfo>();
            Map<String, DatabaseMetaDataWrapper.ColumnsInfo> columnsInfoMap = this.databaseMetaDataWrapper.getColumnsInfo(tableName);
            if (columnsInfoMap != null && !columnsInfoMap.isEmpty()) {
                columnsMetaInfoMap.putAll(columnsInfoMap);
            }
            String tableFieldsSql = this.dbQuery.tableFieldsSql(tableName);
            this.connectManager.execute(tableFieldsSql, result -> {
                String columnName = result.getStringResult(this.dbQuery.fieldName());
                ColumnSchema field = new ColumnSchema();
                field.setName(columnName);
                DatabaseMetaDataWrapper.ColumnsInfo columnsInfo = (DatabaseMetaDataWrapper.ColumnsInfo)columnsMetaInfoMap.get(columnName.toLowerCase());
                if (columnsInfo.isPrimaryKey()) {
                    field.setPrimaryKey(columnsInfo.isAutoIncrement());
                    tableInfo.setIdColumn(field);
                }
                field.setName(columnName);
                field.setDbColumnTypeString(result.getStringResult(this.dbQuery.fieldType()));
                String typeName = field.getDbColumnTypeString();
                int pos = typeName.indexOf("(");
                if (pos > 0) {
                    typeName = typeName.substring(0, pos);
                }
                field.setDataTypeName(typeName);
                field.setComment(columnsInfo.getRemarks());
                field.setCustomMap(this.dbQuery.getCustomFields(result.getResultSet()));
                IColumnType columnType = this.dataSourceConfig.getTypeConvert().processTypeConvert(this.globalConfig, field);
                field.setPropertyName(columnsInfo.getName());
                field.setColumnType(columnType);
                if (columnName.equalsIgnoreCase("status")) {
                    System.out.println("Table " + tableInfo.getName() + " exist status");
                    tableInfo.setIncludeStatus(true);
                }
                tableInfo.addColumn(field);
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

