/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.engine;

import cn.net.vidyo.framework.builder.TemplateModel;
import cn.net.vidyo.framework.builder.config.GlobalConfig;
import cn.net.vidyo.framework.builder.config.Module;
import cn.net.vidyo.framework.builder.config.Project;
import cn.net.vidyo.framework.builder.engine.ITemplateEngine;
import cn.net.vidyo.framework.builder.meta.TableSchema;
import cn.net.vidyo.framework.builder.template.ITemplate;
import java.io.File;
import java.util.Map;

public abstract class AbstractTemplateEngine
implements ITemplateEngine {
    public boolean write(GlobalConfig globalConfig, ITemplate template, Object model) {
        String outputDir = globalConfig.getOutputDir();
        String tableName = "";
        String outFilePath = "";
        if (model instanceof TemplateModel) {
            TemplateModel tmodel = (TemplateModel)model;
            tableName = tmodel.getModel().get("entityName");
            outFilePath = outputDir + template.getPath() + File.separator + template.getPrefix() + tableName + template.getPostfix();
        } else {
            Map map = (Map)model;
            Project project = (Project)map.get("project");
            Module module = (Module)map.get("module");
            TableSchema tableSchema = (TableSchema)map.get("table");
            outFilePath = module.getFullOutpath() + template.getPath() + File.separator + template.getPrefix() + tableSchema.getEntityName() + template.getPostfix();
        }
        File file = new File(outFilePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        System.out.println("build file -->> " + outFilePath);
        return this.write(template.getTemplatePath(), outFilePath, model);
    }
}

