/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.config;

import cn.net.vidyo.framework.builder.converts.MySqlTypeConvert;
import cn.net.vidyo.framework.builder.converts.TypeConverts;
import cn.net.vidyo.framework.builder.domain.DbType;
import cn.net.vidyo.framework.builder.domain.IDbQuery;
import cn.net.vidyo.framework.builder.domain.ITypeConvert;
import cn.net.vidyo.framework.builder.querys.DbQueryRegistry;
import java.util.Optional;

public class DataSourceConfig {
    private String schemaName;
    private ITypeConvert typeConvert;
    private String url;
    private String username;
    private String password;
    private String dirverClassName;
    private IDbQuery dbQuery;

    public IDbQuery getDbQuery() {
        if (null == this.dbQuery) {
            DbType dbType = this.getDbType();
            DbQueryRegistry dbQueryRegistry = new DbQueryRegistry();
            this.dbQuery = Optional.ofNullable(dbQueryRegistry.getDbQuery(dbType)).orElseGet(() -> dbQueryRegistry.getDbQuery(DbType.MYSQL));
        }
        return this.dbQuery;
    }

    public DbType getDbType() {
        return this.getDbType(this.url.toLowerCase());
    }

    private DbType getDbType(String str) {
        if (str.contains(":mysql:") || str.contains(":cobar:")) {
            return DbType.MYSQL;
        }
        if (str.contains(":oracle:")) {
            return DbType.ORACLE;
        }
        if (str.contains(":postgresql:")) {
            return DbType.POSTGRE_SQL;
        }
        if (str.contains(":sqlserver:")) {
            return DbType.SQL_SERVER;
        }
        if (str.contains(":db2:")) {
            return DbType.DB2;
        }
        if (str.contains(":mariadb:")) {
            return DbType.MARIADB;
        }
        if (str.contains(":sqlite:")) {
            return DbType.SQLITE;
        }
        if (str.contains(":h2:")) {
            return DbType.H2;
        }
        if (str.contains(":kingbase:") || str.contains(":kingbase8:")) {
            return DbType.KINGBASE_ES;
        }
        if (str.contains(":dm:")) {
            return DbType.DM;
        }
        if (str.contains(":zenith:")) {
            return DbType.GAUSS;
        }
        if (str.contains(":oscar:")) {
            return DbType.OSCAR;
        }
        if (str.contains(":firebird:")) {
            return DbType.FIREBIRD;
        }
        if (str.contains(":xugu:")) {
            return DbType.XU_GU;
        }
        if (str.contains(":clickhouse:")) {
            return DbType.CLICK_HOUSE;
        }
        if (str.contains(":sybase:")) {
            return DbType.SYBASE;
        }
        return DbType.OTHER;
    }

    public ITypeConvert getTypeConvert() {
        if (null == this.typeConvert) {
            DbType dbType = this.getDbType();
            this.typeConvert = TypeConverts.getTypeConvert(dbType);
            if (null == this.typeConvert) {
                this.typeConvert = MySqlTypeConvert.INSTANCE;
            }
        }
        return this.typeConvert;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTypeConvert(ITypeConvert typeConvert) {
        this.typeConvert = typeConvert;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDirverClassName() {
        return this.dirverClassName;
    }

    public void setDirverClassName(String dirverClassName) {
        this.dirverClassName = dirverClassName;
    }

    public void setDbQuery(IDbQuery dbQuery) {
        this.dbQuery = dbQuery;
    }
}

