/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.meta;

import cn.net.vidyo.framework.builder.domain.DbColumnType;
import cn.net.vidyo.framework.builder.meta.ColumnSchema;
import cn.net.vidyo.framework.common.util.ValueUtil;
import java.util.ArrayList;
import java.util.List;

public class TableSchema {
    String schemaName = "";
    String name = "";
    String entityName = "";
    String comment = "";
    List<ColumnSchema> columns = new ArrayList<ColumnSchema>();
    List<String> excludeColumns = new ArrayList<String>();
    ColumnSchema idColumn = null;
    boolean includeStatus = false;
    boolean includeName = false;

    public TableSchema() {
        this.excludeColumns.add("id");
        this.excludeColumns.add("hidden");
        this.excludeColumns.add("createtime");
        this.excludeColumns.add("updatetime");
    }

    public List<ColumnSchema> getIncludeColumns() {
        ArrayList<ColumnSchema> list = new ArrayList<ColumnSchema>();
        for (ColumnSchema column : this.columns) {
            if (this.excludeColumns.contains(column.getName().toLowerCase())) continue;
            list.add(column);
        }
        return list;
    }

    public void addColumn(ColumnSchema columnSchema) {
        this.columns.add(columnSchema);
        if (columnSchema.getName() == "id") {
            this.idColumn = columnSchema;
        }
    }

    public String getFirstLetterName() {
        return ValueUtil.firstLetterName((String)this.name);
    }

    public String getBaseClassString() {
        DbColumnType columnType = (DbColumnType)this.getIdColumn().getColumnType();
        if (columnType == DbColumnType.STRING) {
            return "StringModel";
        }
        if (columnType == DbColumnType.BIG_INTEGER || columnType == DbColumnType.LONG) {
            return "AutoLongModel";
        }
        if (columnType == DbColumnType.INTEGER) {
            return "AutoIntModel";
        }
        if (columnType == null) {
            System.out.println("columnType is null");
        } else {
            System.out.println("columnType is " + columnType);
        }
        return "";
    }

    public String getKeyClassString() {
        DbColumnType columnType = (DbColumnType)this.getIdColumn().getColumnType();
        if (columnType == DbColumnType.STRING) {
            return "String";
        }
        if (columnType == DbColumnType.BIG_INTEGER || columnType == DbColumnType.LONG) {
            return "Long";
        }
        if (columnType == DbColumnType.INTEGER) {
            return "Integer";
        }
        if (columnType == null) {
            System.out.println("columnType is null");
        } else {
            System.out.println("columnType is " + columnType);
        }
        return "";
    }

    public boolean isIncludeName() {
        return this.includeName;
    }

    public void setIncludeName(boolean includeName) {
        this.includeName = includeName;
    }

    public boolean isIncludeStatus() {
        return this.includeStatus;
    }

    public void setIncludeStatus(boolean includeStatus) {
        this.includeStatus = includeStatus;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.entityName = this.getFirstLetterName();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<ColumnSchema> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnSchema> columns) {
        this.columns = columns;
    }

    public List<String> getExcludeColumns() {
        return this.excludeColumns;
    }

    public void setExcludeColumns(List<String> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    public ColumnSchema getIdColumn() {
        return this.idColumn;
    }

    public void setIdColumn(ColumnSchema idColumn) {
        this.idColumn = idColumn;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }
}

